/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.assets;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import org.blockartistry.mod.Restructured.schematica.Schematic;
import org.blockartistry.mod.Restructured.util.ElementRule;

public final class SchematicProperties
implements Cloneable {
    public String name;
    public int villageWeight;
    public int worldWeight;
    public int limit;
    public int groundOffset;
    public Schematic schematic;
    public boolean suppressFire;
    public boolean suppressMonsterEgg;
    public int villagerCount;
    public int villagerProfession;
    public String chestContents;
    public int chestContentsCount;
    public int spawnerEnableChance;
    public ElementRule dimensions;
    public ElementRule biomes;

    public Map<Block, Integer> analyze() {
        HashMap<Block, Integer> result = new HashMap<Block, Integer>();
        int upperX = this.schematic.getWidth();
        int upperY = this.schematic.getHeight();
        int upperZ = this.schematic.getLength();
        for (int x = 0; x < upperX; ++x) {
            for (int y = 0; y < upperY; ++y) {
                for (int z = 0; z < upperZ; ++z) {
                    Block block = this.schematic.getBlock(x, y, z);
                    if (block == Blocks.field_150350_a) continue;
                    Integer v = result.get(block);
                    v = v == null ? new Integer(1) : new Integer(v + 1);
                    result.put(block, v);
                }
            }
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("[%s] (village: %d; world: %d)", this.name, this.villageWeight, this.worldWeight));
        builder.append(String.format(" (offset: %d; noFire: %s; noEgg: %s)", this.groundOffset, this.suppressFire, this.suppressMonsterEgg));
        builder.append(String.format(" (villagers: %d; profession: %d)", this.villagerCount, this.villagerProfession));
        builder.append(String.format(" (chest: %s, count: %d)", this.chestContents == null ? "<None>" : this.chestContents, this.chestContentsCount));
        builder.append(String.format(" (spawner: %d)", this.spawnerEnableChance));
        return builder.toString();
    }
}

