/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.assets;

import com.google.common.base.Predicate;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.mod.Restructured.assets.ConfigProcessor;
import org.blockartistry.mod.Restructured.assets.SchematicProperties;

public final class ZipProcessor {
    private ZipProcessor() {
    }

    private static File[] getZipFiles(File path) {
        return path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".zip");
            }
        });
    }

    private static File[] getSchematicFiles(File path) {
        return path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".schematic");
            }
        });
    }

    private static void traverseZips(File path, Predicate<ZipEntry> test, Predicate<Object[]> process) {
        for (File file : ZipProcessor.getZipFiles(path)) {
            try {
                ZipFile zip = new ZipFile(file);
                String prefix = StringUtils.removeEnd((String)file.getName(), (String)".zip").toLowerCase().replaceAll("[-.]", "_");
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!test.apply((Object)entry)) continue;
                    InputStream stream = zip.getInputStream(entry);
                    String name = StringUtils.removeEnd((String)entry.getName(), (String)".schematic");
                    process.apply((Object)new Object[]{prefix, name, stream});
                    stream.close();
                }
                zip.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void traverseSchematics(File path, Predicate<Object[]> process) {
        for (File file : ZipProcessor.getSchematicFiles(path)) {
            try {
                FileInputStream stream = new FileInputStream(file);
                String entry = StringUtils.removeEnd((String)file.getName(), (String)".schematic").toLowerCase().replaceAll("[-.]", "_");
                process.apply((Object)new Object[]{"", entry, stream});
                ((InputStream)stream).close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void initialize(File path, Configuration schematics, Configuration chests, List<SchematicProperties> props) {
        ZipProcessor.traverseZips(path, new ConfigProcessor.ChestsConfigFilter(), new ConfigProcessor.ChestsConfigProcess(chests));
        ZipProcessor.traverseZips(path, new ConfigProcessor.SchematicsConfigFilter(), new ConfigProcessor.SchematicsConfigProcess(schematics));
        ZipProcessor.traverseZips(path, new ConfigProcessor.SchematicFilter(), new ConfigProcessor.SchematicsProcess(schematics, props));
        ZipProcessor.traverseSchematics(path, new ConfigProcessor.SchematicsProcess(schematics, props));
    }

    public static boolean areZipsPresent(File path) {
        return ZipProcessor.getZipFiles(path).length > 0;
    }

    public static boolean areSchematicsPresent(File path) {
        return ZipProcessor.getSchematicFiles(path).length > 0;
    }
}

