/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.component;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Direction;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.mod.Restructured.ModLog;
import org.blockartistry.mod.Restructured.assets.SchematicProperties;
import org.blockartistry.mod.Restructured.component.IStructureBuilder;
import org.blockartistry.mod.Restructured.schematica.Schematic;
import org.blockartistry.mod.Restructured.util.BlockHelper;
import org.blockartistry.mod.Restructured.util.Dimensions;
import org.blockartistry.mod.Restructured.util.SelectedBlock;

public class CopyStructureBuilder {
    protected static final Random rand = new Random();
    protected final IStructureBuilder structure;
    protected final World world;
    protected final StructureBoundingBox box;
    protected final int orientation;
    protected final SchematicProperties properties;
    protected final Set<ChunkCoordinates> waitToPlace = new HashSet<ChunkCoordinates>();
    protected final Set<ChunkCoordinates> blockList = new HashSet<ChunkCoordinates>();

    public CopyStructureBuilder(World world, StructureBoundingBox box, int orientation, SchematicProperties properties, IStructureBuilder structure) {
        this.world = world;
        this.box = box;
        this.orientation = orientation;
        this.structure = structure;
        this.properties = properties;
    }

    public void place(SelectedBlock block, int x, int y, int z) {
        this.handleRotation(block);
        this.structure.placeBlock(this.world, block, x, y, z, this.box);
    }

    public boolean isVecInside(int x, int y, int z, StructureBoundingBox box) {
        return this.structure.isVecInside(x, y, z, box);
    }

    public void generate() {
        ChunkCoordinates coord;
        TileEntity entity;
        Schematic schematic = this.properties.schematic;
        Dimensions size = this.structure.getDimensions();
        for (int y = 0; y < size.height; ++y) {
            for (int x = 0; x < size.width; ++x) {
                for (int z = 0; z < size.length; ++z) {
                    ChunkCoordinates v;
                    SelectedBlock block;
                    if (!this.isVecInside(x, y, z, this.box) || this.doSkipSpawnerPlacement(block = schematic.getBlockEx(x, y, z), v = new ChunkCoordinates(x, y, z))) continue;
                    if (this.waitToPlace(block)) {
                        this.waitToPlace.add(v);
                        continue;
                    }
                    this.place(block, x, y, z);
                }
            }
        }
        if (!this.waitToPlace.isEmpty()) {
            for (ChunkCoordinates v : this.waitToPlace) {
                SelectedBlock block = schematic.getBlockEx(v.field_71574_a, v.field_71572_b, v.field_71573_c);
                this.place(block, v.field_71574_a, v.field_71572_b, v.field_71573_c);
            }
        }
        for (Schematic.SchematicTileEntity e : schematic.getTileEntities()) {
            ChunkCoordinates coords = e.coords;
            if (!this.isVecInside(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, this.box) || this.blockList.contains(coords)) continue;
            try {
                entity = (TileEntity)e.getInstance(this.world);
                entity.func_145829_t();
                BlockHelper helper = new BlockHelper(schematic.getBlock(entity.field_145851_c, entity.field_145848_d, entity.field_145849_e));
                coord = this.structure.getWorldCoordinates(entity.field_145851_c, entity.field_145848_d, entity.field_145849_e);
                this.world.func_147455_a(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c, entity);
                if (!this.doFillChestContents(helper)) continue;
                this.generateChestContents((IInventory)entity, this.properties.chestContents, this.properties.chestContentsCount);
            }
            catch (Exception ex) {
                ModLog.warn("Unable to place TileEntity", new Object[0]);
                ex.printStackTrace();
            }
        }
        for (Schematic.SchematicEntity e : schematic.getEntities()) {
            ChunkCoordinates ec = e.coords;
            if (!this.isVecInside(ec.field_71574_a, ec.field_71572_b, ec.field_71573_c, this.box)) continue;
            try {
                entity = (Entity)e.getInstance(this.world);
                if (entity instanceof EntityHanging) {
                    EntityHanging howsIt = (EntityHanging)entity;
                    coord = this.structure.getWorldCoordinates(howsIt.field_146063_b, howsIt.field_146064_c, howsIt.field_146062_d);
                    howsIt.field_146063_b = coord.field_71574_a;
                    howsIt.field_146064_c = coord.field_71572_b;
                    howsIt.field_146062_d = coord.field_71573_c;
                    howsIt.func_82328_a(this.translateDirection(howsIt.field_82332_a));
                } else {
                    ChunkCoordinates coord2 = this.structure.getWorldCoordinates(ec.field_71574_a, ec.field_71572_b, ec.field_71573_c);
                    entity.func_70107_b((double)coord2.field_71574_a + 0.5, (double)coord2.field_71572_b + 0.5, (double)coord2.field_71573_c + 0.5);
                }
                this.world.func_72838_d((Entity)entity);
            }
            catch (Exception t) {
                ModLog.warn("Unable to place entity", new Object[0]);
            }
        }
    }

    protected void generateChestContents(IInventory inventory, String category, int count) {
        WeightedRandomChestContent[] contents = ChestGenHooks.getItems((String)category, (Random)rand);
        if (contents == null || contents.length == 0) {
            ModLog.warn("Unable to get chest contents: %s", category);
        } else {
            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])contents, (IInventory)inventory, (int)count);
        }
    }

    protected boolean doFillChestContents(BlockHelper helper) {
        return helper.isChest() && StringUtils.isNotEmpty((CharSequence)this.properties.chestContents);
    }

    protected boolean doSkipSpawnerPlacement(BlockHelper helper, ChunkCoordinates v) {
        if (helper.isSpawner() && rand.nextInt(100) >= this.properties.spawnerEnableChance) {
            this.blockList.add(v);
            return true;
        }
        return false;
    }

    protected boolean waitToPlace(BlockHelper block) {
        return block.isTorch() || block.isLever() || block.isButton() || block.isDoor();
    }

    protected int translateDirection(int dir) {
        int count = this.getRotationCount(dir);
        if (count == 1) {
            return Direction.field_71577_f[dir];
        }
        if (count == 2) {
            return Direction.field_71580_e[dir];
        }
        if (count == 3) {
            return Direction.field_71578_g[dir];
        }
        return dir;
    }

    protected int getRotationCount(int dir) {
        switch (dir) {
            case 0: {
                return this.getRotationCount(ForgeDirection.SOUTH);
            }
            case 1: {
                return this.getRotationCount(ForgeDirection.WEST);
            }
            case 2: {
                return this.getRotationCount(ForgeDirection.NORTH);
            }
            case 4: {
                return this.getRotationCount(ForgeDirection.EAST);
            }
        }
        return -1;
    }

    protected int getRotationCount(ForgeDirection dir) {
        int rotationCount = 0;
        if (this.orientation == 1 || this.orientation == 3) {
            ++rotationCount;
        }
        if (!(this.orientation != 2 && this.orientation != 3 || dir != ForgeDirection.NORTH && dir != ForgeDirection.SOUTH)) {
            rotationCount += 2;
        }
        return rotationCount;
    }

    protected void handleRotation(SelectedBlock block) {
        if (this.orientation == 0) {
            return;
        }
        ForgeDirection direction = block.getOrientation();
        if (direction == ForgeDirection.UNKNOWN || direction == ForgeDirection.UP || direction == ForgeDirection.DOWN) {
            return;
        }
        block.rotate(ForgeDirection.UP, this.getRotationCount(direction));
    }
}

