/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.component;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import org.blockartistry.mod.Restructured.assets.Assets;
import org.blockartistry.mod.Restructured.assets.SchematicProperties;
import org.blockartistry.mod.Restructured.component.CopyStructureBuilder;
import org.blockartistry.mod.Restructured.component.IStructureBuilder;
import org.blockartistry.mod.Restructured.component.VillageStructureBase;
import org.blockartistry.mod.Restructured.schematica.Schematic;
import org.blockartistry.mod.Restructured.util.BlockHelper;
import org.blockartistry.mod.Restructured.util.Dimensions;

public class SchematicStructure
extends VillageStructureBase
implements IStructureBuilder {
    protected SchematicProperties properties;
    protected BiomeGenBase biome;

    public SchematicStructure() {
        super(null, 0, null, null, 0);
    }

    public SchematicStructure(StructureVillagePieces.Start start, int type, Random rand, StructureBoundingBox box, int direction) {
        super(start, type, rand, box, direction);
        this.biome = start.biome;
    }

    public void setProperties(SchematicProperties props) {
        this.properties = props;
    }

    protected void func_143012_a(NBTTagCompound nbt) {
        super.func_143012_a(nbt);
        nbt.func_74778_a("key", this.properties.name);
        nbt.func_74768_a("biome", this.biome.field_76756_M);
    }

    protected void func_143011_b(NBTTagCompound nbt) {
        int b;
        super.func_143011_b(nbt);
        String temp = nbt.func_74779_i("key");
        if (temp != null) {
            this.properties = Assets.getProperties(temp);
        }
        this.biome = (b = nbt.func_74762_e("biome")) == 0 ? BiomeGenBase.field_76772_c : BiomeGenBase.func_150568_d((int)b);
    }

    @Override
    public Dimensions getDimensions() {
        return this.properties.schematic.getDimensions();
    }

    @Override
    public int getGroundOffset() {
        return this.properties.groundOffset;
    }

    public String getName() {
        return this.properties.name;
    }

    @Override
    public void build(World world, Random rand, StructureBoundingBox box) {
        CopyStructureBuilder builder = new CopyStructureBuilder(world, box, this.field_74885_f, this.properties, this);
        builder.generate();
    }

    protected ChunkCoordinates getSafeVillagerLocation() {
        Dimensions size = this.properties.schematic.getDimensions();
        int x = size.width >> 1;
        int z = size.length >> 1;
        int y = this.properties.groundOffset;
        Schematic s = this.properties.schematic;
        for (int i = 0; i < 4; ++i) {
            BlockHelper block = new BlockHelper(s.getBlock(x, y + 1, z));
            if (block.canBreath()) {
                if (s.getBlock(x, y, z) == Blocks.field_150350_a) break;
                ++y;
                break;
            }
            x += 1 - rand.nextInt(3);
            z += 1 - rand.nextInt(3);
        }
        return new ChunkCoordinates(x, y, z);
    }

    @Override
    public void spawnPeople(World world, StructureBoundingBox box) {
        int count = this.properties.villagerCount;
        if (count == -1) {
            count = rand.nextInt(4);
        }
        if (count == 0) {
            return;
        }
        ChunkCoordinates loc = this.getSafeVillagerLocation();
        this.func_74893_a(world, box, loc.field_71574_a, loc.field_71572_b, loc.field_71573_c, count);
    }

    protected int func_74888_b(int p_74888_1_) {
        int type = this.properties.villagerProfession;
        if (type == -1) {
            type = rand.nextInt(5);
        }
        return type;
    }

    @Override
    public boolean isVecInside(int x, int y, int z, StructureBoundingBox box) {
        ChunkCoordinates v = this.getWorldCoordinates(x, y, z);
        return box.func_78890_b(v.field_71574_a, v.field_71572_b, v.field_71573_c);
    }

    @Override
    public ChunkCoordinates getWorldCoordinates(int x, int y, int z) {
        return new ChunkCoordinates(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
    }

    @Override
    public ChunkCoordinates getWorldCoordinates(ChunkCoordinates v) {
        return this.getWorldCoordinates(v.field_71574_a, v.field_71572_b, v.field_71573_c);
    }
}

