/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.component;

import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import org.blockartistry.mod.Restructured.ModLog;
import org.blockartistry.mod.Restructured.assets.Assets;
import org.blockartistry.mod.Restructured.assets.SchematicProperties;
import org.blockartistry.mod.Restructured.component.SchematicPieceWeight;
import org.blockartistry.mod.Restructured.component.SchematicStructure;
import org.blockartistry.mod.Restructured.util.Dimensions;

public class SchematicStructureCreationHandler
implements VillagerRegistry.IVillageCreationHandler {
    public SchematicStructureCreationHandler() {
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)this);
    }

    public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int i) {
        return new SchematicPieceWeight(Assets.getTableForVillageGen());
    }

    public Class<?> getComponentClass() {
        return SchematicStructure.class;
    }

    public Object buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List pieces, Random random, int x, int y, int z, int orientation, int type) {
        if (!(villagePiece instanceof SchematicPieceWeight)) {
            return null;
        }
        SchematicPieceWeight pw = (SchematicPieceWeight)villagePiece;
        SchematicProperties props = pw.getNextStructure();
        if (props == null) {
            return null;
        }
        Dimensions size = props.schematic.getDimensions();
        StructureBoundingBox _boundingBox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)size.width, (int)size.height, (int)size.length, (int)orientation);
        if (this.canVillageGoDeeper(_boundingBox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)_boundingBox) == null) {
            try {
                ModLog.debug("Village structure [%s] @(%s); mode %d", props.name, _boundingBox, orientation);
                SchematicStructure struct = new SchematicStructure(startPiece, type, random, _boundingBox, orientation);
                struct.setProperties(props);
                return struct;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private boolean canVillageGoDeeper(StructureBoundingBox _boundingBox) {
        return _boundingBox != null && _boundingBox.field_78895_b > 10;
    }

    static {
        MapGenStructureIO.func_143031_a(SchematicStructure.class, (String)"reSS");
    }
}

