/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.schematica;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import org.blockartistry.mod.Restructured.util.Dimensions;
import org.blockartistry.mod.Restructured.util.SelectedBlock;
import org.blockartistry.mod.Restructured.world.themes.BlockThemes;

public class Schematic {
    private final SelectedBlock[] data;
    private final List<SchematicTileEntity> tileEntities = new ArrayList<SchematicTileEntity>();
    private final List<SchematicEntity> entities = new ArrayList<SchematicEntity>();
    private final int width;
    private final int height;
    private final int length;
    private final int widthOffset;
    private final int heightOffset;
    private final Dimensions dim;

    public Schematic(int width, int height, int length) {
        this.data = new SelectedBlock[width * height * length];
        this.width = width;
        this.height = height;
        this.length = length;
        this.dim = new Dimensions(width, height, length);
        this.widthOffset = height * length;
        this.heightOffset = length;
    }

    public void scrubFireSources() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = BlockThemes.scrubFireSource(this.data[i]);
        }
    }

    public void scrubEggs() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = BlockThemes.scrubEggs(this.data[i]);
        }
    }

    public Dimensions getDimensions() {
        return this.dim;
    }

    protected int getDataIndex(int x, int y, int z) {
        return x * this.widthOffset + y * this.heightOffset + z;
    }

    public SelectedBlock getBlockEx(int x, int y, int z) {
        if (!this.isValid(x, y, z)) {
            return new SelectedBlock(Blocks.field_150350_a);
        }
        return (SelectedBlock)this.data[this.getDataIndex(x, y, z)].clone();
    }

    public Block getBlock(int x, int y, int z) {
        if (!this.isValid(x, y, z)) {
            return Blocks.field_150350_a;
        }
        return this.data[this.getDataIndex(x, y, z)].getBlock();
    }

    public boolean setBlock(int x, int y, int z, Block block, int metadata) {
        if (!this.isValid(x, y, z)) {
            return false;
        }
        this.data[this.getDataIndex((int)x, (int)y, (int)z)] = new SelectedBlock(block, metadata);
        return true;
    }

    public SchematicTileEntity getTileEntity(int x, int y, int z) {
        for (SchematicTileEntity entry : this.tileEntities) {
            ChunkCoordinates coords = entry.coords;
            if (coords.field_71574_a != x || coords.field_71572_b != y || coords.field_71573_c != z) continue;
            return entry;
        }
        return null;
    }

    public List<SchematicTileEntity> getTileEntities() {
        return this.tileEntities;
    }

    public void addTileEntity(int x, int y, int z, NBTTagCompound nbt) {
        if (!this.isValid(x, y, z)) {
            return;
        }
        this.removeTileEntity(x, y, z);
        if (nbt != null) {
            this.tileEntities.add(new SchematicTileEntity(nbt, x, y, z));
        }
    }

    public void removeTileEntity(int x, int y, int z) {
        Iterator<SchematicTileEntity> iterator = this.tileEntities.iterator();
        while (iterator.hasNext()) {
            ChunkCoordinates coord = iterator.next().coords;
            if (coord.field_71574_a != x || coord.field_71572_b != y || coord.field_71573_c != z) continue;
            iterator.remove();
        }
    }

    public int getBlockMetadata(int x, int y, int z) {
        if (!this.isValid(x, y, z)) {
            return 0;
        }
        return this.data[this.getDataIndex(x, y, z)].getMeta();
    }

    public List<SchematicEntity> getEntities() {
        return this.entities;
    }

    public void addEntity(UUID id, NBTTagCompound nbt, int x, int y, int z) {
        for (SchematicEntity e : this.entities) {
            if (!id.equals(e.id)) continue;
            return;
        }
        this.entities.add(new SchematicEntity(id, nbt, x, y, z));
    }

    public int getWidth() {
        return this.width;
    }

    public int getLength() {
        return this.length;
    }

    public int getHeight() {
        return this.height;
    }

    private boolean isValid(int x, int y, int z) {
        return x >= 0 && y >= 0 && z >= 0 && x < this.width && y < this.height && z < this.length;
    }

    public static class SchematicEntity
    extends SchematicTileEntity {
        public final UUID id;

        public SchematicEntity(UUID id, NBTTagCompound nbt, int x, int y, int z) {
            super(nbt, x, y, z);
            this.id = id;
        }

        @Override
        public Object getInstance(World world) {
            return EntityList.func_75615_a((NBTTagCompound)this.nbt, (World)world);
        }
    }

    public static class SchematicTileEntity {
        public final ChunkCoordinates coords;
        public final NBTTagCompound nbt;

        public SchematicTileEntity(NBTTagCompound nbt, int x, int y, int z) {
            this.coords = new ChunkCoordinates(x, y, z);
            this.nbt = nbt;
        }

        public Object getInstance(World world) {
            return TileEntity.func_145827_c((NBTTagCompound)this.nbt);
        }
    }
}

