/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.schematica;

import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.blockartistry.mod.Restructured.ModLog;
import org.blockartistry.mod.Restructured.schematica.Schematic;
import org.blockartistry.mod.Restructured.schematica.SchematicFormat;
import org.blockartistry.mod.Restructured.world.FantasyIsland;

public class SchematicAlpha
extends SchematicFormat {
    private static final FMLControlledNamespacedRegistry<Block> BLOCK_REGISTRY = GameData.getBlockRegistry();

    @Override
    public Schematic readFromNBT(NBTTagCompound tagCompound) {
        byte[] localBlocks = tagCompound.func_74770_j("Blocks");
        byte[] localMetadata = tagCompound.func_74770_j("Data");
        boolean extra = false;
        byte[] extraBlocks = null;
        if (tagCompound.func_74764_b("AddBlocks")) {
            extra = true;
            byte[] extraBlocksNibble = tagCompound.func_74770_j("AddBlocks");
            extraBlocks = new byte[extraBlocksNibble.length * 2];
            for (int i = 0; i < extraBlocksNibble.length; ++i) {
                extraBlocks[i * 2 + 0] = (byte)(extraBlocksNibble[i] >> 4 & 0xF);
                extraBlocks[i * 2 + 1] = (byte)(extraBlocksNibble[i] & 0xF);
            }
        } else if (tagCompound.func_74764_b("Add")) {
            extra = true;
            extraBlocks = tagCompound.func_74770_j("Add");
        }
        int width = tagCompound.func_74765_d("Width");
        int length = tagCompound.func_74765_d("Length");
        int height = tagCompound.func_74765_d("Height");
        HashMap<Short, Short> oldToNew = new HashMap<Short, Short>();
        if (tagCompound.func_74764_b("SchematicaMapping")) {
            NBTTagCompound mapping = tagCompound.func_74775_l("SchematicaMapping");
            Set names = mapping.func_150296_c();
            for (String name : names) {
                oldToNew.put(mapping.func_74765_d(name), (short)BLOCK_REGISTRY.getId(name));
            }
        }
        Schematic schematic = new Schematic(width, height, length);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = x + (y * length + z) * width;
                    int blockID = localBlocks[index] & 0xFF | (extra ? (extraBlocks[index] & 0xFF) << 8 : 0);
                    int meta = localMetadata[index] & 0xFF;
                    Short id = null;
                    id = (Short)oldToNew.get((short)blockID);
                    if (id != null) {
                        blockID = id.shortValue();
                    }
                    schematic.setBlock(x, y, z, (Block)BLOCK_REGISTRY.func_148754_a(blockID), meta);
                }
            }
        }
        if (tagCompound.func_74764_b("TileEntities")) {
            NBTTagList tileEntitiesList = tagCompound.func_150295_c("TileEntities", 10);
            for (int i = 0; i < tileEntitiesList.func_74745_c(); ++i) {
                try {
                    NBTTagCompound tc = tileEntitiesList.func_150305_b(i);
                    TileEntity tileEntity = TileEntity.func_145827_c((NBTTagCompound)tc);
                    if (tileEntity == null) continue;
                    schematic.addTileEntity(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tc);
                    continue;
                }
                catch (Exception e) {
                    ModLog.error("TileEntity failed to load properly!", e);
                }
            }
        }
        if (tagCompound.func_74764_b("WEOriginX") && tagCompound.func_74764_b("WEOriginY") && tagCompound.func_74764_b("WEOriginZ")) {
            int originX = tagCompound.func_74762_e("WEOriginX");
            int originY = tagCompound.func_74762_e("WEOriginY");
            int originZ = tagCompound.func_74762_e("WEOriginZ");
            NBTTagList entitiesList = tagCompound.func_150295_c("Entities", 10);
            for (int i = 0; i < entitiesList.func_74745_c(); ++i) {
                try {
                    NBTTagCompound cp = entitiesList.func_150305_b(i);
                    Entity entity = EntityList.func_75615_a((NBTTagCompound)cp, (World)FantasyIsland.instance);
                    entity.field_70165_t -= (double)originX;
                    entity.field_70163_u -= (double)originY;
                    entity.field_70161_v -= (double)originZ;
                    if (entity instanceof EntityHanging) {
                        EntityHanging howsIt = (EntityHanging)entity;
                        howsIt.field_146063_b -= originX;
                        howsIt.field_146064_c -= originY;
                        howsIt.field_146062_d -= originZ;
                    }
                    NBTTagCompound repack = new NBTTagCompound();
                    entity.func_70039_c(repack);
                    schematic.addEntity(entity.func_110124_au(), repack, MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v));
                    continue;
                }
                catch (Exception e) {
                    ModLog.error("Entity failed to load properly!", e);
                }
            }
        }
        return schematic;
    }
}

