/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.schematica;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import org.blockartistry.mod.Restructured.ModLog;
import org.blockartistry.mod.Restructured.schematica.Schematic;
import org.blockartistry.mod.Restructured.schematica.SchematicAlpha;
import org.blockartistry.mod.Restructured.schematica.SchematicUtil;
import org.blockartistry.mod.Restructured.schematica.UnsupportedFormatException;

public abstract class SchematicFormat {
    public static final Map<String, SchematicFormat> FORMATS = new HashMap<String, SchematicFormat>();
    public static String FORMAT_DEFAULT;

    public abstract Schematic readFromNBT(NBTTagCompound var1);

    public static Schematic readFromStream(InputStream stream) {
        try {
            NBTTagCompound tagCompound = SchematicUtil.readTagCompoundFromStream(stream);
            String format = tagCompound.func_74779_i("Materials");
            SchematicFormat schematicFormat = FORMATS.get(format);
            if (schematicFormat == null) {
                throw new UnsupportedFormatException(format);
            }
            return schematicFormat.readFromNBT(tagCompound);
        }
        catch (Exception ex) {
            ModLog.error("Failed to read schematic!", ex);
            return null;
        }
    }

    public static Schematic readFromFile(File file) {
        try {
            NBTTagCompound tagCompound = SchematicUtil.readTagCompoundFromFile(file);
            String format = tagCompound.func_74779_i("Materials");
            SchematicFormat schematicFormat = FORMATS.get(format);
            if (schematicFormat == null) {
                throw new UnsupportedFormatException(format);
            }
            return schematicFormat.readFromNBT(tagCompound);
        }
        catch (Exception ex) {
            ModLog.error("Failed to read schematic!", ex);
            return null;
        }
    }

    public static Schematic readFromFile(File directory, String filename) {
        return SchematicFormat.readFromFile(new File(directory, filename));
    }

    static {
        FORMATS.put("Alpha", new SchematicAlpha());
        FORMAT_DEFAULT = "Alpha";
    }
}

