/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockVine;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;
import org.blockartistry.mod.Restructured.util.SelectedBlock;

public enum BlockType {
    UNKNOWN,
    LOG,
    DISPENSER,
    BED,
    RAIL,
    RAIL_POWERED,
    RAIL_ASCENDING,
    RAIL_CORNER,
    TORCH,
    STAIR,
    CHEST,
    SIGNPOST,
    DOOR,
    LEVER,
    BUTTON,
    REDSTONE_REPEATER,
    TRAPDOOR,
    MUSHROOM_CAP,
    MUSHROOM_CAP_CORNER,
    MUSHROOM_CAP_SIDE,
    VINE,
    SKULL,
    ANVIL;

    private static final Map<BlockType, BiMap<Integer, ForgeDirection>> MAPPINGS;
    private static final HashMap<Class<? extends Block>, BlockType> blockToType;

    private static boolean isKnownUnknown(Block block) {
        return block.getClass() == Block.class || block == Blocks.field_150350_a;
    }

    public static BlockType myType(Block block) {
        if (BlockType.isKnownUnknown(block)) {
            return UNKNOWN;
        }
        if (block == Blocks.field_150444_as) {
            return CHEST;
        }
        if (block == Blocks.field_150472_an) {
            return SIGNPOST;
        }
        BlockType bt = blockToType.get(block.getClass());
        if (bt == null) {
            Class<?> searchFor = block.getClass();
            for (Map.Entry<Class<? extends Block>, BlockType> e : blockToType.entrySet()) {
                if (!e.getKey().isAssignableFrom(searchFor)) continue;
                bt = e.getValue();
                break;
            }
            if (bt == null) {
                bt = UNKNOWN;
            }
            blockToType.put(searchFor, bt);
        }
        return bt;
    }

    public static ForgeDirection getOrientation(SelectedBlock block) {
        BlockType type = BlockType.myType(block.getBlock());
        if (type == UNKNOWN) {
            return ForgeDirection.UNKNOWN;
        }
        return BlockType.metadataToDirection(type, block.getMeta());
    }

    private static ForgeDirection metadataToDirection(BlockType blockType, int meta) {
        BiMap<Integer, ForgeDirection> biMap;
        if (blockType == LEVER) {
            if (meta == 6) {
                meta = 5;
            } else if (meta == 0) {
                meta = 7;
            }
        }
        if (blockType == BED) {
            meta &= 3;
        }
        if (MAPPINGS.containsKey((Object)blockType) && (biMap = MAPPINGS.get((Object)blockType)).containsKey((Object)meta)) {
            return (ForgeDirection)biMap.get((Object)meta);
        }
        if (blockType == TORCH) {
            return ForgeDirection.getOrientation((int)(6 - meta));
        }
        if (blockType == STAIR) {
            return ForgeDirection.getOrientation((int)(5 - (meta & 3)));
        }
        if (blockType == CHEST || blockType == DISPENSER || blockType == SKULL || blockType == BED) {
            return ForgeDirection.getOrientation((int)meta);
        }
        if (blockType == BUTTON) {
            return ForgeDirection.getOrientation((int)(6 - meta));
        }
        if (blockType == TRAPDOOR) {
            return ForgeDirection.getOrientation((int)((meta & 3) + 2)).getOpposite();
        }
        if (blockType == SIGNPOST) {
            if (meta < 3) {
                return ForgeDirection.SOUTH;
            }
            if (meta < 7) {
                return ForgeDirection.WEST;
            }
            if (meta < 11) {
                return ForgeDirection.NORTH;
            }
            if (meta < 16) {
                return ForgeDirection.EAST;
            }
            return ForgeDirection.SOUTH;
        }
        if (blockType == LOG) {
            if (meta < 4) {
                return ForgeDirection.UP;
            }
            if (meta < 8) {
                return ForgeDirection.EAST;
            }
            if (meta < 12) {
                return ForgeDirection.SOUTH;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    static {
        MAPPINGS = new HashMap<BlockType, BiMap<Integer, ForgeDirection>>();
        blockToType = new HashMap();
        blockToType.put(BlockLog.class, LOG);
        blockToType.put(BlockOldLog.class, LOG);
        blockToType.put(BlockNewLog.class, LOG);
        blockToType.put(BlockTorch.class, TORCH);
        blockToType.put(BlockStairs.class, STAIR);
        blockToType.put(BlockBed.class, BED);
        blockToType.put(BlockPumpkin.class, BED);
        blockToType.put(BlockFenceGate.class, BED);
        blockToType.put(BlockEndPortalFrame.class, BED);
        blockToType.put(BlockTripWireHook.class, BED);
        blockToType.put(BlockCocoa.class, BED);
        blockToType.put(BlockRail.class, RAIL);
        blockToType.put(BlockRailPowered.class, RAIL_POWERED);
        blockToType.put(BlockRailDetector.class, RAIL_POWERED);
        blockToType.put(BlockChest.class, CHEST);
        blockToType.put(BlockEnderChest.class, CHEST);
        blockToType.put(BlockFurnace.class, CHEST);
        blockToType.put(BlockLadder.class, CHEST);
        blockToType.put(BlockDoor.class, DOOR);
        blockToType.put(BlockButton.class, BUTTON);
        blockToType.put(BlockRedstoneRepeater.class, REDSTONE_REPEATER);
        blockToType.put(BlockRedstoneComparator.class, REDSTONE_REPEATER);
        blockToType.put(BlockTrapDoor.class, TRAPDOOR);
        blockToType.put(BlockHugeMushroom.class, MUSHROOM_CAP);
        blockToType.put(BlockVine.class, VINE);
        blockToType.put(BlockSkull.class, SKULL);
        blockToType.put(BlockAnvil.class, ANVIL);
        blockToType.put(BlockDispenser.class, DISPENSER);
        blockToType.put(BlockPistonBase.class, DISPENSER);
        blockToType.put(BlockPistonExtension.class, DISPENSER);
        blockToType.put(BlockHopper.class, DISPENSER);
        blockToType.put(BlockLever.class, LEVER);
        HashBiMap biMap = HashBiMap.create((int)4);
        biMap.put((Object)0, (Object)ForgeDirection.SOUTH);
        biMap.put((Object)1, (Object)ForgeDirection.WEST);
        biMap.put((Object)2, (Object)ForgeDirection.NORTH);
        biMap.put((Object)3, (Object)ForgeDirection.EAST);
        MAPPINGS.put(BED, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)4);
        biMap.put((Object)2, (Object)ForgeDirection.EAST);
        biMap.put((Object)3, (Object)ForgeDirection.WEST);
        biMap.put((Object)4, (Object)ForgeDirection.NORTH);
        biMap.put((Object)5, (Object)ForgeDirection.SOUTH);
        MAPPINGS.put(RAIL_ASCENDING, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)4);
        biMap.put((Object)6, (Object)ForgeDirection.WEST);
        biMap.put((Object)7, (Object)ForgeDirection.NORTH);
        biMap.put((Object)8, (Object)ForgeDirection.EAST);
        biMap.put((Object)9, (Object)ForgeDirection.SOUTH);
        MAPPINGS.put(RAIL_CORNER, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)6);
        biMap.put((Object)1, (Object)ForgeDirection.EAST);
        biMap.put((Object)2, (Object)ForgeDirection.WEST);
        biMap.put((Object)3, (Object)ForgeDirection.SOUTH);
        biMap.put((Object)4, (Object)ForgeDirection.NORTH);
        biMap.put((Object)5, (Object)ForgeDirection.UP);
        biMap.put((Object)7, (Object)ForgeDirection.DOWN);
        MAPPINGS.put(LEVER, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)4);
        biMap.put((Object)0, (Object)ForgeDirection.WEST);
        biMap.put((Object)1, (Object)ForgeDirection.NORTH);
        biMap.put((Object)2, (Object)ForgeDirection.EAST);
        biMap.put((Object)3, (Object)ForgeDirection.SOUTH);
        MAPPINGS.put(DOOR, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)4);
        biMap.put((Object)0, (Object)ForgeDirection.NORTH);
        biMap.put((Object)1, (Object)ForgeDirection.EAST);
        biMap.put((Object)2, (Object)ForgeDirection.SOUTH);
        biMap.put((Object)3, (Object)ForgeDirection.WEST);
        MAPPINGS.put(REDSTONE_REPEATER, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)4);
        biMap.put((Object)1, (Object)ForgeDirection.EAST);
        biMap.put((Object)3, (Object)ForgeDirection.SOUTH);
        biMap.put((Object)7, (Object)ForgeDirection.NORTH);
        biMap.put((Object)9, (Object)ForgeDirection.WEST);
        MAPPINGS.put(MUSHROOM_CAP_CORNER, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)4);
        biMap.put((Object)2, (Object)ForgeDirection.NORTH);
        biMap.put((Object)4, (Object)ForgeDirection.WEST);
        biMap.put((Object)6, (Object)ForgeDirection.EAST);
        biMap.put((Object)8, (Object)ForgeDirection.SOUTH);
        MAPPINGS.put(MUSHROOM_CAP_SIDE, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)2);
        biMap.put((Object)0, (Object)ForgeDirection.SOUTH);
        biMap.put((Object)1, (Object)ForgeDirection.EAST);
        MAPPINGS.put(ANVIL, (BiMap<Integer, ForgeDirection>)biMap);
        biMap = HashBiMap.create((int)4);
        biMap.put((Object)1, (Object)ForgeDirection.SOUTH);
        biMap.put((Object)2, (Object)ForgeDirection.WEST);
        biMap.put((Object)4, (Object)ForgeDirection.NORTH);
        biMap.put((Object)8, (Object)ForgeDirection.EAST);
        MAPPINGS.put(VINE, (BiMap<Integer, ForgeDirection>)biMap);
    }
}

