/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.util;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.common.util.RotationHelper;
import org.blockartistry.mod.Restructured.util.BlockHelper;
import org.blockartistry.mod.Restructured.util.BlockType;
import org.blockartistry.mod.Restructured.world.FantasyIsland;

public class SelectedBlock
extends BlockHelper
implements Cloneable {
    private static final ThreadLocal<SelectedBlock> flyweight = new ThreadLocal<SelectedBlock>(){

        @Override
        protected SelectedBlock initialValue() {
            return new SelectedBlock();
        }
    };
    protected int meta;

    public static SelectedBlock fly(Block block, int meta) {
        SelectedBlock t = flyweight.get();
        t.block = block;
        t.meta = meta;
        return t;
    }

    protected SelectedBlock() {
        this(null, 0);
    }

    public SelectedBlock(Block block) {
        this(block, 0);
    }

    public SelectedBlock(Block block, int meta) {
        super(block);
        this.meta = block == Blocks.field_150350_a ? 0 : meta;
    }

    public int getMeta() {
        return this.meta;
    }

    public void rotate(ForgeDirection axis, int count) {
        FantasyIsland.instance.meta = this.meta;
        for (int i = 0; i < count; ++i) {
            RotationHelper.rotateVanillaBlock((Block)this.block, (World)FantasyIsland.instance, (int)0, (int)0, (int)0, (ForgeDirection)axis);
        }
        this.meta = FantasyIsland.instance.meta;
    }

    public ForgeDirection getOrientation() {
        return BlockType.getOrientation(this);
    }

    public Object clone() {
        return new SelectedBlock(this.block, this.meta);
    }
}

