/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.util;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class WeightTable<T extends Item> {
    static final Random random = new Random();
    private ArrayList<T> items = new ArrayList();
    private Random rand = random;
    private int totalWeight = 0;

    public WeightTable() {
        this(null);
    }

    public WeightTable(Random rand) {
        if (rand != null) {
            this.rand = rand;
        }
    }

    public void add(T entry) {
        this.totalWeight += ((Item)entry).itemWeight;
        this.items.add(entry);
    }

    public void remove(T entry) {
        if (this.items.remove(entry)) {
            this.totalWeight -= ((Item)entry).itemWeight;
        }
    }

    public T next() {
        assert (this.totalWeight > 0);
        int targetWeight = this.rand.nextInt(this.totalWeight);
        int i = 0;
        i = this.items.size();
        while ((targetWeight -= ((Item)this.items.get((int)(i - 1))).itemWeight) >= 0) {
            --i;
        }
        return (T)((Item)this.items.get(i - 1));
    }

    public int size() {
        return this.items.size();
    }

    public List<T> getEntries() {
        return Collections.unmodifiableList(this.items);
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public void diagnostic(String title, Writer writer) throws IOException {
        writer.write(String.format("\nWeight table [%s] (total weight %d):\n", title, this.totalWeight));
        writer.write("==========================================================\n");
        for (Item i : this.items) {
            writer.write(String.format("%5.1f%% (%4d) %s\n", (double)i.itemWeight * 100.0 / (double)this.totalWeight, i.itemWeight, i.toString()));
        }
    }

    public static abstract class Item
    implements Cloneable {
        public final int itemWeight;
        protected final Random rnd;

        public Item(int weight) {
            this.itemWeight = weight;
            this.rnd = random;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

