/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.world;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import org.blockartistry.mod.Restructured.ModLog;
import org.blockartistry.mod.Restructured.ModOptions;

public final class MobControl {
    private static final boolean BLOCK_CREEPER_BLOCK_DAMAGE = ModOptions.getBlockCreeperExplosion();
    private static final boolean BLOCK_MOB_TREE_SPAWNING = ModOptions.getBlockMobsSpawningInTrees();

    private MobControl() {
    }

    private static void setup(EnumCreatureType type, int factor) {
        if (factor != 0) {
            type.field_75606_e = factor;
        }
        ModLog.info("Mob %s spawn factor is %d", type.name(), type.field_75606_e);
    }

    public static void initialize() {
        MobControl.setup(EnumCreatureType.ambient, ModOptions.getMobSpawnAmbientFactor());
        MobControl.setup(EnumCreatureType.creature, ModOptions.getMobSpawnAnimalFactor());
        MobControl.setup(EnumCreatureType.monster, ModOptions.getMobSpawnMobFactor());
        MobControl.setup(EnumCreatureType.waterCreature, ModOptions.getMobSpawnWaterFactor());
        if (BLOCK_CREEPER_BLOCK_DAMAGE || BLOCK_MOB_TREE_SPAWNING) {
            if (BLOCK_CREEPER_BLOCK_DAMAGE) {
                ModLog.info("Blocking Creeper block damage", new Object[0]);
            }
            if (BLOCK_MOB_TREE_SPAWNING) {
                ModLog.info("Blocking mob tree spawning", new Object[0]);
            }
            MinecraftForge.EVENT_BUS.register((Object)new MobControl());
        }
        if (ModOptions.getBlockEndermanGriefing()) {
            try {
                Field carriable = ReflectionHelper.findField(EntityEnderman.class, (String[])new String[]{"carriable"});
                if (carriable != null) {
                    carriable.set(null, new IdentityHashMap());
                    ModLog.info("Blocking Enderman griefing", new Object[0]);
                }
            }
            catch (Exception ex) {
                ModLog.warn("Unable to access Enderman block table", new Object[0]);
            }
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Detonate event) {
        if (!BLOCK_CREEPER_BLOCK_DAMAGE) {
            return;
        }
        if (event.explosion.field_77283_e instanceof EntityCreeper) {
            event.explosion.field_77281_g = ImmutableList.of();
        }
    }

    @SubscribeEvent
    public void onMobSpawn(LivingSpawnEvent.CheckSpawn event) {
        int z;
        int y;
        if (!BLOCK_MOB_TREE_SPAWNING) {
            return;
        }
        int x = MathHelper.func_76141_d((float)event.x);
        Block block = event.world.func_147439_a(x, y = MathHelper.func_76141_d((float)event.y) - 1, z = MathHelper.func_76141_d((float)event.z));
        if (block.canSustainLeaves((IBlockAccess)event.world, x, y, z)) {
            event.setResult(Event.Result.DENY);
        }
    }
}

