/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.world;

import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public final class RegionHelper {
    private RegionHelper() {
    }

    public static RegionStats getRegionStatsWithVariance(World world, StructureBoundingBox worldBB) {
        int avgGroundLevel = world.field_73011_w.func_76557_i() - 1;
        RegionStats result = new RegionStats();
        result.area = worldBB.func_78883_b() * worldBB.func_78880_d();
        int[] data = new int[result.area];
        int total = 0;
        int index = 0;
        for (int z = worldBB.field_78896_c; z <= worldBB.field_78892_f; ++z) {
            for (int x = worldBB.field_78897_a; x <= worldBB.field_78893_d; ++x) {
                int val = Math.max(world.func_72825_h(x, z), avgGroundLevel);
                total += val;
                data[index++] = val;
                if (!world.func_147439_a(x, val - 1, z).func_149688_o().func_76224_d()) continue;
                ++result.water;
            }
        }
        result.mean = Math.round((float)total / (float)index);
        int accum = 0;
        for (int i = 0; i < index; ++i) {
            int t = data[i] - result.mean;
            accum += t * t;
        }
        result.variance = Math.round((float)accum / (float)index);
        return result;
    }

    public static int getRegionAverageGroundLevel(World world, StructureBoundingBox worldBB) {
        int avgGroundLevel = world.field_73011_w.func_76557_i() - 1;
        int area = worldBB.func_78883_b() * worldBB.func_78880_d();
        int total = 0;
        for (int z = worldBB.field_78896_c; z <= worldBB.field_78892_f; ++z) {
            for (int x = worldBB.field_78897_a; x <= worldBB.field_78893_d; ++x) {
                total += Math.max(world.func_72825_h(x, z), avgGroundLevel);
            }
        }
        return total / area;
    }

    public static class RegionStats {
        public int area;
        public int mean;
        public int variance;
        public int water;

        public String toString() {
            return String.format("[area: %d; mean: %d; variance: %d, water: %d]", this.area, this.mean, this.variance, this.water);
        }
    }
}

