/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.world;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.village.Village;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import org.blockartistry.mod.Restructured.ModOptions;
import org.blockartistry.mod.Restructured.assets.Assets;
import org.blockartistry.mod.Restructured.assets.SchematicProperties;
import org.blockartistry.mod.Restructured.assets.SchematicWeightItem;
import org.blockartistry.mod.Restructured.util.WeightTable;
import org.blockartistry.mod.Restructured.world.BiomeHelper;
import org.blockartistry.mod.Restructured.world.SchematicWorldGenStructure;

public class SchematicWorldGenHandler
implements IWorldGenerator {
    private static final int ONE_IN_N_CHANCE = ModOptions.getGenerationChance();
    private static final int MINIMUM_SPAWN_DISTANCE = 4;
    private static final int MINIMUM_VILLAGE_DISTANCE_SQUARED = 64;
    private static final int MINIMUM_GEN_DISTANCE_SQUARED = 64;
    private static final Set<ChunkCoordIntPair> activeGeneration = new HashSet<ChunkCoordIntPair>();

    private static ChunkCoordinates getRandomStart(Random rand, int chunkX, int chunkZ) {
        int x = (chunkX << 4) + 3 + rand.nextInt(8);
        int z = (chunkZ << 4) + 3 + rand.nextInt(8);
        return new ChunkCoordinates(x, 0, z);
    }

    private static long distanceSq(ChunkCoordIntPair pt1, ChunkCoordIntPair pt2) {
        long dX = pt1.field_77276_a - pt2.field_77276_a;
        long dZ = pt1.field_77275_b - pt2.field_77275_b;
        return dX * dX + dZ * dZ;
    }

    private static long distanceSq(ChunkCoordinates pt1, ChunkCoordinates pt2) {
        long dX = pt1.field_71574_a - pt2.field_71574_a >> 4;
        long dZ = pt1.field_71573_c - pt2.field_71573_c >> 4;
        return dX * dX + dZ * dZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tooCloseToOtherGen(ChunkCoordIntPair loc) {
        Set<ChunkCoordIntPair> set = activeGeneration;
        synchronized (set) {
            if (activeGeneration.isEmpty()) {
                return false;
            }
            for (ChunkCoordIntPair a : activeGeneration) {
                if (SchematicWorldGenHandler.distanceSq(loc, a) > 64L) continue;
                return true;
            }
        }
        return false;
    }

    public SchematicWorldGenHandler() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)200);
    }

    private static boolean anyVillagesTooClose(World world, ChunkCoordinates loc) {
        if (world.field_72982_D == null) {
            return false;
        }
        List villageList = world.field_72982_D.func_75540_b();
        for (Village v : villageList) {
            if (SchematicWorldGenHandler.distanceSq(loc, v.func_75577_a()) >= 64L) continue;
            return true;
        }
        return false;
    }

    private static boolean tooCloseToSpawn(World world, ChunkCoordinates loc) {
        return SchematicWorldGenHandler.distanceSq(loc, world.func_72861_E()) < 4L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_72995_K) {
            return;
        }
        if (!world.func_72912_H().func_76089_r()) {
            return;
        }
        if (ONE_IN_N_CHANCE < 1 || random.nextInt(ONE_IN_N_CHANCE) > 0) {
            return;
        }
        ChunkCoordIntPair currentGen = new ChunkCoordIntPair(chunkX, chunkZ);
        Set<ChunkCoordIntPair> set = activeGeneration;
        synchronized (set) {
            if (SchematicWorldGenHandler.tooCloseToOtherGen(currentGen) || !activeGeneration.add(currentGen)) {
                return;
            }
        }
        try {
            ChunkCoordinates start = SchematicWorldGenHandler.getRandomStart(random, chunkX, chunkZ);
            if (SchematicWorldGenHandler.anyVillagesTooClose(world, start) || SchematicWorldGenHandler.tooCloseToSpawn(world, start)) {
                return;
            }
            int dimension = world.field_73011_w.field_76574_g;
            BiomeGenBase biome = BiomeHelper.chunkBiomeSurvey(world, chunkGenerator.func_73154_d(chunkX, chunkZ), random);
            WeightTable<SchematicWeightItem> structs = Assets.getTableForWorldGen(dimension, biome);
            if (structs.size() == 0) {
                return;
            }
            SchematicProperties props = structs.next().properties;
            int orientation = random.nextInt(4);
            SchematicWorldGenStructure structure = new SchematicWorldGenStructure(world, biome, orientation, start.field_71574_a, start.field_71573_c, props);
            structure.build();
        }
        finally {
            Set<ChunkCoordIntPair> set2 = activeGeneration;
            synchronized (set2) {
                activeGeneration.remove(currentGen);
            }
        }
    }
}

