/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.world;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import org.blockartistry.mod.Restructured.ModLog;
import org.blockartistry.mod.Restructured.assets.SchematicProperties;
import org.blockartistry.mod.Restructured.component.CopyStructureBuilder;
import org.blockartistry.mod.Restructured.component.IStructureBuilder;
import org.blockartistry.mod.Restructured.util.BlockHelper;
import org.blockartistry.mod.Restructured.util.Dimensions;
import org.blockartistry.mod.Restructured.util.SelectedBlock;
import org.blockartistry.mod.Restructured.world.RegionHelper;
import org.blockartistry.mod.Restructured.world.themes.BlockThemes;

public class SchematicWorldGenStructure
implements IStructureBuilder {
    private static final SelectedBlock DIRT_BLOCK = new SelectedBlock(Blocks.field_150346_d, 0);
    private static final int VARIANCE_THRESHOLD = 3;
    private static final int WATER_RATIO_THRESHOLD = 35;
    protected final World world;
    protected int direction;
    protected final SchematicProperties properties;
    protected StructureBoundingBox boundingBox;
    protected final BiomeGenBase biome;

    public SchematicWorldGenStructure(World world, BiomeGenBase biome, int direction, int x, int z, SchematicProperties properties) {
        Dimensions size = properties.schematic.getDimensions();
        this.world = world;
        this.direction = direction;
        this.properties = properties;
        this.biome = biome;
        this.boundingBox = StructureBoundingBox.func_78889_a((int)x, (int)1, (int)z, (int)0, (int)0, (int)0, (int)size.width, (int)size.height, (int)size.length, (int)direction);
    }

    @Override
    public Dimensions getDimensions() {
        return this.properties.schematic.getDimensions();
    }

    @Override
    public boolean isVecInside(int x, int y, int z, StructureBoundingBox box) {
        ChunkCoordinates v = this.getWorldCoordinates(x, y, z);
        return box.func_78890_b(v.field_71574_a, v.field_71572_b, v.field_71573_c);
    }

    @Override
    public ChunkCoordinates getWorldCoordinates(int x, int y, int z) {
        return new ChunkCoordinates(this.getXWithOffset(x, z), this.getYWithOffset(y), this.getZWithOffset(x, z));
    }

    @Override
    public ChunkCoordinates getWorldCoordinates(ChunkCoordinates v) {
        return this.getWorldCoordinates(v.field_71574_a, v.field_71572_b, v.field_71573_c);
    }

    @Override
    public void placeBlock(World world, SelectedBlock block, int x, int y, int z, StructureBoundingBox box) {
        int k1;
        int j1;
        int i1 = this.getXWithOffset(x, z);
        if (box.func_78890_b(i1, j1 = this.getYWithOffset(y), k1 = this.getZWithOffset(x, z))) {
            SelectedBlock blockToPlace = BlockThemes.findReplacement(this.biome, block);
            world.func_147465_d(i1, j1, k1, blockToPlace.getBlock(), blockToPlace.getMeta(), 2);
        }
    }

    protected int getXWithOffset(int x, int z) {
        switch (this.direction) {
            case 0: 
            case 2: {
                return this.boundingBox.field_78897_a + x;
            }
            case 1: {
                return this.boundingBox.field_78893_d - z;
            }
            case 3: {
                return this.boundingBox.field_78897_a + z;
            }
        }
        return x;
    }

    protected int getYWithOffset(int y) {
        return this.direction == -1 ? y : y + this.boundingBox.field_78895_b;
    }

    protected int getZWithOffset(int x, int z) {
        switch (this.direction) {
            case 0: {
                return this.boundingBox.field_78896_c + z;
            }
            case 1: 
            case 3: {
                return this.boundingBox.field_78896_c + x;
            }
            case 2: {
                return this.boundingBox.field_78892_f - z;
            }
        }
        return z;
    }

    protected void clearUpwards(int x, int y, int z, StructureBoundingBox box) {
        int l = this.getXWithOffset(x, z);
        int j1 = this.getZWithOffset(x, z);
        int i1 = this.getYWithOffset(y);
        if (box.func_78890_b(l, i1, j1)) {
            while (!this.world.func_147437_c(l, i1, j1) && i1 < 255) {
                this.world.func_147465_d(l, i1++, j1, Blocks.field_150350_a, 0, 2);
            }
        }
    }

    protected void clearDownwards(Block block, int meta, int x, int y, int z, StructureBoundingBox box) {
        int i1 = this.getXWithOffset(x, z);
        int k1 = this.getZWithOffset(x, z);
        int j1 = this.getYWithOffset(y);
        if (box.func_78890_b(i1, j1, k1)) {
            BlockHelper helper;
            while ((helper = new BlockHelper(this.world.func_147439_a(i1, j1, k1))).isAir() || helper.isLiquid() || !helper.isSolid()) {
                this.world.func_147465_d(i1, j1--, k1, block, meta, 2);
                if (j1 > 1) continue;
            }
        }
    }

    protected boolean prepare(StructureBoundingBox box) {
        RegionHelper.RegionStats stats = RegionHelper.getRegionStatsWithVariance(this.world, this.boundingBox);
        if (stats.variance > 3) {
            return false;
        }
        if (stats.water > 0 && stats.area * 100 / stats.water > 35) {
            return false;
        }
        int offset = this.properties.groundOffset;
        this.boundingBox.func_78886_a(0, stats.mean - this.boundingBox.field_78895_b - offset, 0);
        ModLog.debug("WorldGen structure [%s] @(%s); mode %d", this.properties.name, this.boundingBox, this.direction);
        ModLog.debug(stats.toString(), new Object[0]);
        SelectedBlock blockToPlace = BlockThemes.findReplacement(this.biome, DIRT_BLOCK);
        Dimensions size = this.getDimensions();
        for (int xx = 0; xx < size.width; ++xx) {
            for (int zz = 0; zz < size.length; ++zz) {
                this.clearUpwards(xx, 0, zz, box);
                this.clearDownwards(blockToPlace.getBlock(), blockToPlace.getMeta(), xx, -1, zz, box);
            }
        }
        return true;
    }

    public void build() {
        StructureBoundingBox box = new StructureBoundingBox(this.boundingBox.field_78897_a, 1, this.boundingBox.field_78896_c, this.boundingBox.field_78893_d, 512, this.boundingBox.field_78892_f);
        if (!this.prepare(box)) {
            return;
        }
        CopyStructureBuilder builder = new CopyStructureBuilder(this.world, box, this.direction, this.properties, this);
        builder.generate();
    }
}

