/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.Restructured.world.themes;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenMutated;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import org.blockartistry.mod.Restructured.util.SelectedBlock;

public final class BlockThemes {
    private static final Map<BiomeGenBase, Map<Block, SelectedBlock>> themes = new IdentityHashMap<BiomeGenBase, Map<Block, SelectedBlock>>();
    private static final int KEEP_META = -1;
    private static final SelectedBlock AIR = new SelectedBlock(Blocks.field_150350_a);
    private static final SelectedBlock[] monsterBlockMap = new SelectedBlock[]{new SelectedBlock(Blocks.field_150348_b), new SelectedBlock(Blocks.field_150347_e), new SelectedBlock(Blocks.field_150417_aV), new SelectedBlock(Blocks.field_150417_aV, 1), new SelectedBlock(Blocks.field_150417_aV, 2), new SelectedBlock(Blocks.field_150417_aV, 3)};

    private static void register(BiomeGenBase biome, Map<Block, SelectedBlock> theme) {
        themes.put(biome, theme);
        BiomeGenBase mutation = BiomeGenBase.func_150568_d((int)(biome.field_76756_M + 128));
        if (mutation instanceof BiomeGenMutated) {
            themes.put(mutation, theme);
        }
    }

    private static Block biomeBlockReplace(BiomeGenBase biome, SelectedBlock block) {
        Map<Block, SelectedBlock> replacements = themes.get(biome);
        if (replacements == null) {
            return block.getBlock();
        }
        SelectedBlock code = replacements.get(block.getBlock());
        return code != null ? code.getBlock() : block.getBlock();
    }

    private static int biomeMetaReplace(BiomeGenBase biome, SelectedBlock block) {
        Map<Block, SelectedBlock> replacements = themes.get(biome);
        if (replacements == null) {
            return block.getMeta();
        }
        SelectedBlock code = replacements.get(block.getBlock());
        if (code == null || code.getMeta() == -1) {
            return block.getMeta();
        }
        int replace = code.getMeta();
        if (block.isSlab()) {
            replace |= block.getMeta() & 8;
        } else if (block.isLog()) {
            replace |= block.getMeta() & 0xC;
        }
        return replace;
    }

    public static SelectedBlock scrubEggs(SelectedBlock block) {
        if (block.getBlock() != Blocks.field_150418_aU) {
            return block;
        }
        int idx = block.getMeta();
        if (idx >= monsterBlockMap.length) {
            return block;
        }
        return monsterBlockMap[idx];
    }

    public static SelectedBlock scrubFireSource(SelectedBlock block) {
        if (block.isFireSource()) {
            return (SelectedBlock)AIR.clone();
        }
        return block;
    }

    public static SelectedBlock findReplacement(BiomeGenBase biome, SelectedBlock block) {
        Block theBlock = block.getBlock();
        int meta = block.getMeta();
        BiomeEvent.GetVillageBlockID event1 = new BiomeEvent.GetVillageBlockID(biome, theBlock, meta);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event1);
        if (event1.getResult() == Event.Result.DENY) {
            theBlock = event1.replacement;
        }
        BiomeEvent.GetVillageBlockMeta event2 = new BiomeEvent.GetVillageBlockMeta(biome, block.getBlock(), block.getMeta());
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event2);
        if (event2.getResult() == Event.Result.DENY) {
            meta = event2.replacement;
        }
        return new SelectedBlock(theBlock, meta);
    }

    public static void initialize() {
        IdentityHashMap<Object, SelectedBlock> mappings = new IdentityHashMap<Block, SelectedBlock>();
        mappings.put(Blocks.field_150346_d, new SelectedBlock((Block)Blocks.field_150354_m, 0));
        mappings.put(Blocks.field_150349_c, new SelectedBlock((Block)Blocks.field_150354_m, 0));
        mappings.put(Blocks.field_150328_O, new SelectedBlock((Block)Blocks.field_150330_I, 0));
        mappings.put(Blocks.field_150327_N, new SelectedBlock((Block)Blocks.field_150330_I, 0));
        mappings.put(Blocks.field_150337_Q, AIR);
        mappings.put(Blocks.field_150338_P, AIR);
        mappings.put(Blocks.field_150398_cm, AIR);
        mappings.put(Blocks.field_150329_H, AIR);
        BlockThemes.register(BiomeGenBase.field_76787_r, mappings);
        BlockThemes.register(BiomeGenBase.field_150577_O, mappings);
        mappings = new IdentityHashMap();
        mappings.put(Blocks.field_150346_d, new SelectedBlock(Blocks.field_150348_b, 0));
        mappings.put(Blocks.field_150349_c, new SelectedBlock(Blocks.field_150348_b, 0));
        mappings.put(Blocks.field_150328_O, new SelectedBlock((Block)Blocks.field_150337_Q, 0));
        mappings.put(Blocks.field_150327_N, new SelectedBlock((Block)Blocks.field_150338_P, 0));
        mappings.put(Blocks.field_150398_cm, AIR);
        mappings.put(Blocks.field_150329_H, AIR);
        BlockThemes.register(BiomeGenBase.field_150576_N, mappings);
        mappings = new IdentityHashMap();
        mappings.put(Blocks.field_150364_r, new SelectedBlock(Blocks.field_150364_r, 2));
        mappings.put(Blocks.field_150363_s, new SelectedBlock(Blocks.field_150364_r, 2));
        mappings.put(Blocks.field_150344_f, new SelectedBlock(Blocks.field_150344_f, 2));
        mappings.put(Blocks.field_150485_bF, new SelectedBlock(Blocks.field_150487_bG, -1));
        mappings.put(Blocks.field_150476_ad, new SelectedBlock(Blocks.field_150487_bG, -1));
        mappings.put(Blocks.field_150401_cl, new SelectedBlock(Blocks.field_150487_bG, -1));
        mappings.put(Blocks.field_150481_bH, new SelectedBlock(Blocks.field_150487_bG, -1));
        mappings.put(Blocks.field_150400_ck, new SelectedBlock(Blocks.field_150487_bG, -1));
        mappings.put(Blocks.field_150376_bx, new SelectedBlock((Block)Blocks.field_150376_bx, 2));
        mappings.put(Blocks.field_150373_bw, new SelectedBlock((Block)Blocks.field_150373_bw, 2));
        BlockThemes.register(BiomeGenBase.field_150583_P, mappings);
        BlockThemes.register(BiomeGenBase.field_150582_Q, mappings);
        mappings = new IdentityHashMap();
        mappings.put(Blocks.field_150364_r, new SelectedBlock(Blocks.field_150322_A, 0));
        mappings.put(Blocks.field_150363_s, new SelectedBlock(Blocks.field_150322_A, 0));
        mappings.put(Blocks.field_150347_e, new SelectedBlock(Blocks.field_150322_A, 0));
        mappings.put(Blocks.field_150344_f, new SelectedBlock(Blocks.field_150322_A, 2));
        mappings.put(Blocks.field_150476_ad, new SelectedBlock(Blocks.field_150372_bz, -1));
        mappings.put(Blocks.field_150446_ar, new SelectedBlock(Blocks.field_150372_bz, -1));
        mappings.put(Blocks.field_150485_bF, new SelectedBlock(Blocks.field_150372_bz, -1));
        mappings.put(Blocks.field_150487_bG, new SelectedBlock(Blocks.field_150372_bz, -1));
        mappings.put(Blocks.field_150401_cl, new SelectedBlock(Blocks.field_150372_bz, -1));
        mappings.put(Blocks.field_150400_ck, new SelectedBlock(Blocks.field_150372_bz, -1));
        mappings.put(Blocks.field_150351_n, new SelectedBlock(Blocks.field_150322_A, -1));
        mappings.put(Blocks.field_150376_bx, new SelectedBlock((Block)Blocks.field_150333_U, 1));
        mappings.put(Blocks.field_150333_U, new SelectedBlock((Block)Blocks.field_150333_U, 1));
        mappings.put(Blocks.field_150373_bw, new SelectedBlock(Blocks.field_150322_A, 0));
        mappings.put(Blocks.field_150334_T, new SelectedBlock(Blocks.field_150322_A, 0));
        mappings.put(Blocks.field_150346_d, new SelectedBlock((Block)Blocks.field_150354_m, 0));
        mappings.put(Blocks.field_150349_c, new SelectedBlock((Block)Blocks.field_150354_m, 0));
        mappings.put(Blocks.field_150328_O, new SelectedBlock((Block)Blocks.field_150330_I, 0));
        mappings.put(Blocks.field_150327_N, new SelectedBlock((Block)Blocks.field_150330_I, 0));
        mappings.put(Blocks.field_150337_Q, AIR);
        mappings.put(Blocks.field_150338_P, AIR);
        mappings.put(Blocks.field_150398_cm, AIR);
        mappings.put(Blocks.field_150329_H, AIR);
        BlockThemes.register(BiomeGenBase.field_76769_d, mappings);
        BlockThemes.register(BiomeGenBase.field_76786_s, mappings);
        mappings = new IdentityHashMap();
        mappings.put(Blocks.field_150364_r, new SelectedBlock(Blocks.field_150364_r, 0));
        mappings.put(Blocks.field_150363_s, new SelectedBlock(Blocks.field_150364_r, 0));
        mappings.put(Blocks.field_150344_f, new SelectedBlock(Blocks.field_150344_f, 0));
        mappings.put(Blocks.field_150485_bF, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150487_bG, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150401_cl, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150481_bH, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150400_ck, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150376_bx, new SelectedBlock((Block)Blocks.field_150376_bx, 0));
        mappings.put(Blocks.field_150373_bw, new SelectedBlock((Block)Blocks.field_150373_bw, 0));
        BlockThemes.register(BiomeGenBase.field_76767_f, mappings);
        BlockThemes.register(BiomeGenBase.field_76785_t, mappings);
        mappings = new IdentityHashMap();
        mappings.put(Blocks.field_150364_r, new SelectedBlock(Blocks.field_150364_r, 3));
        mappings.put(Blocks.field_150363_s, new SelectedBlock(Blocks.field_150364_r, 3));
        mappings.put(Blocks.field_150344_f, new SelectedBlock(Blocks.field_150344_f, 3));
        mappings.put(Blocks.field_150485_bF, new SelectedBlock(Blocks.field_150481_bH, -1));
        mappings.put(Blocks.field_150476_ad, new SelectedBlock(Blocks.field_150481_bH, -1));
        mappings.put(Blocks.field_150401_cl, new SelectedBlock(Blocks.field_150481_bH, -1));
        mappings.put(Blocks.field_150487_bG, new SelectedBlock(Blocks.field_150481_bH, -1));
        mappings.put(Blocks.field_150400_ck, new SelectedBlock(Blocks.field_150481_bH, -1));
        mappings.put(Blocks.field_150376_bx, new SelectedBlock((Block)Blocks.field_150376_bx, 3));
        mappings.put(Blocks.field_150373_bw, new SelectedBlock((Block)Blocks.field_150373_bw, 3));
        BlockThemes.register(BiomeGenBase.field_76782_w, mappings);
        BlockThemes.register(BiomeGenBase.field_150574_L, mappings);
        BlockThemes.register(BiomeGenBase.field_76792_x, mappings);
        mappings = new IdentityHashMap();
        mappings.put(Blocks.field_150364_r, new SelectedBlock(Blocks.field_150363_s, 1));
        mappings.put(Blocks.field_150363_s, new SelectedBlock(Blocks.field_150363_s, 1));
        mappings.put(Blocks.field_150344_f, new SelectedBlock(Blocks.field_150344_f, 5));
        mappings.put(Blocks.field_150485_bF, new SelectedBlock(Blocks.field_150401_cl, -1));
        mappings.put(Blocks.field_150476_ad, new SelectedBlock(Blocks.field_150401_cl, -1));
        mappings.put(Blocks.field_150487_bG, new SelectedBlock(Blocks.field_150401_cl, -1));
        mappings.put(Blocks.field_150481_bH, new SelectedBlock(Blocks.field_150401_cl, -1));
        mappings.put(Blocks.field_150400_ck, new SelectedBlock(Blocks.field_150401_cl, -1));
        mappings.put(Blocks.field_150376_bx, new SelectedBlock((Block)Blocks.field_150376_bx, 5));
        mappings.put(Blocks.field_150373_bw, new SelectedBlock((Block)Blocks.field_150373_bw, 5));
        BlockThemes.register(BiomeGenBase.field_150585_R, mappings);
        mappings = new IdentityHashMap();
        mappings.put(Blocks.field_150364_r, new SelectedBlock(Blocks.field_150363_s, 0));
        mappings.put(Blocks.field_150363_s, new SelectedBlock(Blocks.field_150363_s, 0));
        mappings.put(Blocks.field_150344_f, new SelectedBlock(Blocks.field_150344_f, 4));
        mappings.put(Blocks.field_150485_bF, new SelectedBlock(Blocks.field_150400_ck, -1));
        mappings.put(Blocks.field_150476_ad, new SelectedBlock(Blocks.field_150400_ck, -1));
        mappings.put(Blocks.field_150401_cl, new SelectedBlock(Blocks.field_150400_ck, -1));
        mappings.put(Blocks.field_150481_bH, new SelectedBlock(Blocks.field_150400_ck, -1));
        mappings.put(Blocks.field_150487_bG, new SelectedBlock(Blocks.field_150400_ck, -1));
        mappings.put(Blocks.field_150376_bx, new SelectedBlock((Block)Blocks.field_150376_bx, 4));
        mappings.put(Blocks.field_150373_bw, new SelectedBlock((Block)Blocks.field_150373_bw, 4));
        BlockThemes.register(BiomeGenBase.field_150588_X, mappings);
        BlockThemes.register(BiomeGenBase.field_150587_Y, mappings);
        mappings = new IdentityHashMap();
        mappings.put(Blocks.field_150364_r, new SelectedBlock(Blocks.field_150364_r, 1));
        mappings.put(Blocks.field_150363_s, new SelectedBlock(Blocks.field_150364_r, 1));
        mappings.put(Blocks.field_150344_f, new SelectedBlock(Blocks.field_150344_f, 1));
        mappings.put(Blocks.field_150476_ad, new SelectedBlock(Blocks.field_150485_bF, -1));
        mappings.put(Blocks.field_150487_bG, new SelectedBlock(Blocks.field_150485_bF, -1));
        mappings.put(Blocks.field_150401_cl, new SelectedBlock(Blocks.field_150485_bF, -1));
        mappings.put(Blocks.field_150481_bH, new SelectedBlock(Blocks.field_150485_bF, -1));
        mappings.put(Blocks.field_150400_ck, new SelectedBlock(Blocks.field_150485_bF, -1));
        mappings.put(Blocks.field_150376_bx, new SelectedBlock((Block)Blocks.field_150376_bx, 1));
        mappings.put(Blocks.field_150373_bw, new SelectedBlock((Block)Blocks.field_150373_bw, 1));
        BlockThemes.register(BiomeGenBase.field_150584_S, mappings);
        BlockThemes.register(BiomeGenBase.field_150579_T, mappings);
        BlockThemes.register(BiomeGenBase.field_150578_U, mappings);
        BlockThemes.register(BiomeGenBase.field_150581_V, mappings);
        BlockThemes.register(BiomeGenBase.field_76768_g, mappings);
        BlockThemes.register(BiomeGenBase.field_76784_u, mappings);
        mappings = new IdentityHashMap();
        mappings.put((Block)Blocks.field_150349_c, new SelectedBlock((Block)Blocks.field_150391_bh));
        mappings.put(Blocks.field_150364_r, new SelectedBlock(Blocks.field_150419_aX));
        mappings.put(Blocks.field_150363_s, new SelectedBlock(Blocks.field_150419_aX));
        mappings.put(Blocks.field_150344_f, new SelectedBlock(Blocks.field_150420_aW));
        mappings.put(Blocks.field_150328_O, new SelectedBlock((Block)Blocks.field_150337_Q));
        mappings.put(Blocks.field_150327_N, new SelectedBlock((Block)Blocks.field_150338_P, 0));
        mappings.put(Blocks.field_150398_cm, AIR);
        mappings.put(Blocks.field_150329_H, AIR);
        BlockThemes.register(BiomeGenBase.field_76789_p, mappings);
        BlockThemes.register(BiomeGenBase.field_76788_q, mappings);
        mappings = new IdentityHashMap();
        mappings.put(Blocks.field_150364_r, new SelectedBlock(Blocks.field_150364_r, 0));
        mappings.put(Blocks.field_150363_s, new SelectedBlock(Blocks.field_150364_r, 0));
        mappings.put(Blocks.field_150344_f, new SelectedBlock(Blocks.field_150344_f, 0));
        mappings.put(Blocks.field_150485_bF, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150487_bG, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150401_cl, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150481_bH, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150400_ck, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150376_bx, new SelectedBlock((Block)Blocks.field_150376_bx, 0));
        mappings.put(Blocks.field_150373_bw, new SelectedBlock((Block)Blocks.field_150373_bw, 0));
        mappings.put(Blocks.field_150328_O, new SelectedBlock((Block)Blocks.field_150328_O, 1));
        mappings.put(Blocks.field_150327_N, new SelectedBlock((Block)Blocks.field_150338_P, 0));
        BlockThemes.register(BiomeGenBase.field_76780_h, mappings);
        mappings = new IdentityHashMap();
        mappings.put(Blocks.field_150346_d, new SelectedBlock((Block)Blocks.field_150354_m, 1));
        mappings.put(Blocks.field_150349_c, new SelectedBlock((Block)Blocks.field_150354_m, 1));
        mappings.put(Blocks.field_150364_r, new SelectedBlock(Blocks.field_150364_r, 0));
        mappings.put(Blocks.field_150363_s, new SelectedBlock(Blocks.field_150364_r, 0));
        mappings.put(Blocks.field_150344_f, new SelectedBlock(Blocks.field_150405_ch));
        mappings.put(Blocks.field_150485_bF, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150487_bG, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150401_cl, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150481_bH, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150400_ck, new SelectedBlock(Blocks.field_150476_ad, -1));
        mappings.put(Blocks.field_150376_bx, new SelectedBlock((Block)Blocks.field_150376_bx, 0));
        mappings.put(Blocks.field_150373_bw, new SelectedBlock((Block)Blocks.field_150373_bw, 0));
        mappings.put(Blocks.field_150328_O, new SelectedBlock((Block)Blocks.field_150330_I));
        mappings.put(Blocks.field_150327_N, new SelectedBlock((Block)Blocks.field_150330_I));
        mappings.put(Blocks.field_150337_Q, AIR);
        mappings.put(Blocks.field_150338_P, AIR);
        mappings.put(Blocks.field_150398_cm, AIR);
        mappings.put(Blocks.field_150329_H, AIR);
        BlockThemes.register(BiomeGenBase.field_150589_Z, mappings);
        BlockThemes.register(BiomeGenBase.field_150608_ab, mappings);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new BlockThemes());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void blockReplaceEvent(BiomeEvent.GetVillageBlockID event) {
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        Block replace = BlockThemes.biomeBlockReplace(event.biome, SelectedBlock.fly(event.original, event.type));
        if (replace != event.original) {
            event.replacement = replace;
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void blockMetaReplaceEvent(BiomeEvent.GetVillageBlockMeta event) {
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        int replace = BlockThemes.biomeMetaReplace(event.biome, SelectedBlock.fly(event.original, event.type));
        if (replace != event.type) {
            event.replacement = replace;
            event.setResult(Event.Result.DENY);
        }
    }
}

