/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.saltmod.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.saltmod.common.CommonProxy;
import ru.liahim.saltmod.common.ModBlocks;

public class SaltBlock
extends Block {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    protected boolean crystal = true;

    public SaltBlock(CreativeTabs tab) {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.DEFAULT)));
        this.func_149675_a(true);
        this.func_149647_a(tab);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 1);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (meta == EnumType.LINES_Y.getMetadata()) {
            switch (facing.func_176740_k()) {
                case Z: {
                    return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.LINES_Z));
                }
                case X: {
                    return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.LINES_X));
                }
            }
            return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.LINES_Y));
        }
        if (meta == EnumType.BLOCKCHISELED.getMetadata()) {
            return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.BLOCKCHISELED));
        }
        if (meta == EnumType.BRICK.getMetadata()) {
            return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.BRICK));
        }
        if (meta == EnumType.BLOCKCRACKED.getMetadata()) {
            return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.BLOCKCRACKED));
        }
        if (meta == EnumType.BRICKCRACKED.getMetadata()) {
            return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.BRICKCRACKED));
        }
        if (meta == EnumType.BRICKCHISELED.getMetadata()) {
            return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.BRICKCHISELED));
        }
        if (meta == EnumType.CHAPITER.getMetadata()) {
            return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.CHAPITER));
        }
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.DEFAULT));
    }

    public int func_180651_a(IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b((IProperty)VARIANT));
        return type != EnumType.LINES_X && type != EnumType.LINES_Z ? type.getMetadata() : EnumType.LINES_Y.getMetadata();
    }

    protected ItemStack func_180643_i(IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b((IProperty)VARIANT));
        return type != EnumType.LINES_X && type != EnumType.LINES_Z ? super.func_180643_i(state) : new ItemStack(Item.func_150898_a((Block)this), 1, EnumType.LINES_Y.getMetadata());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, EnumType.DEFAULT.getMetadata()));
        list.add(new ItemStack(item, 1, EnumType.BLOCKCHISELED.getMetadata()));
        list.add(new ItemStack(item, 1, EnumType.LINES_Y.getMetadata()));
        list.add(new ItemStack(item, 1, EnumType.BRICK.getMetadata()));
        list.add(new ItemStack(item, 1, EnumType.BLOCKCRACKED.getMetadata()));
        list.add(new ItemStack(item, 1, EnumType.BRICKCRACKED.getMetadata()));
        list.add(new ItemStack(item, 1, EnumType.BRICKCHISELED.getMetadata()));
        list.add(new ItemStack(item, 1, EnumType.CHAPITER.getMetadata()));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VARIANT});
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        for (IProperty prop : state.func_177228_b().keySet()) {
            EnumType next;
            if (!prop.func_177701_a().equals("variant") || prop.func_177699_b() != EnumType.class) continue;
            EnumType current = (EnumType)((Object)state.func_177229_b(prop));
            EnumType enumType = current == EnumType.LINES_X ? EnumType.LINES_Y : (current == EnumType.LINES_Y ? EnumType.LINES_Z : (next = current == EnumType.LINES_Z ? EnumType.LINES_X : current));
            if (next == current) {
                return false;
            }
            world.func_175656_a(pos, state.func_177226_a(prop, (Comparable)((Object)next)));
            return true;
        }
        return false;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.saltDamage(worldIn, entityIn);
        super.func_176199_a(worldIn, pos, entityIn);
    }

    private void saltDamage(World worldIn, Entity entity) {
        if (entity instanceof EntityLivingBase && EntityList.func_75621_b((Entity)entity) != null && (EntityList.func_75621_b((Entity)entity).toLowerCase().contains("slime") && !EntityList.func_75621_b((Entity)entity).toLowerCase().contains("lava") || EntityList.func_75621_b((Entity)entity).toLowerCase().contains("witch"))) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            BlockPos posUp = new BlockPos((Vec3i)pos.func_177984_a());
            if (!(world.func_180495_p(posUp.func_177974_f()).func_177230_c() != ModBlocks.saltBlock && world.func_180495_p(posUp.func_177974_f()).func_177230_c() != ModBlocks.saltSlabDouble || world.func_180495_p(posUp.func_177976_e()).func_177230_c() != ModBlocks.saltBlock && world.func_180495_p(posUp.func_177976_e()).func_177230_c() != ModBlocks.saltSlabDouble || world.func_180495_p(posUp.func_177978_c()).func_177230_c() != ModBlocks.saltBlock && world.func_180495_p(posUp.func_177978_c()).func_177230_c() != ModBlocks.saltSlabDouble || world.func_180495_p(posUp.func_177968_d()).func_177230_c() != ModBlocks.saltBlock && world.func_180495_p(posUp.func_177968_d()).func_177230_c() != ModBlocks.saltSlabDouble || world.func_180495_p(posUp.func_177982_a(1, 0, 1)).func_177230_c().func_149688_o() != Material.field_151586_h || world.func_180495_p(posUp.func_177982_a(1, 0, -1)).func_177230_c().func_149688_o() != Material.field_151586_h || world.func_180495_p(posUp.func_177982_a(-1, 0, 1)).func_177230_c().func_149688_o() != Material.field_151586_h || world.func_180495_p(posUp.func_177982_a(-1, 0, -1)).func_177230_c().func_149688_o() != Material.field_151586_h || world.func_175671_l(posUp) >= 15)) {
                if (rand.nextInt(CommonProxy.saltCrystalGrowSpeed) == 0 && this.crystal) {
                    if (world.func_175623_d(posUp)) {
                        world.func_180501_a(posUp, ModBlocks.saltCrystal.func_176203_a(2), 3);
                    } else if (world.func_180495_p(posUp).func_177230_c() == ModBlocks.saltCrystal && world.func_180495_p(posUp).func_177230_c().func_176201_c(world.func_180495_p(posUp)) == 2) {
                        world.func_180501_a(posUp, ModBlocks.saltCrystal.func_176203_a(1), 3);
                    } else if (world.func_180495_p(posUp).func_177230_c() == ModBlocks.saltCrystal && world.func_180495_p(posUp).func_177230_c().func_176201_c(world.func_180495_p(posUp)) == 1) {
                        world.func_180501_a(posUp, ModBlocks.saltCrystal.func_176223_P(), 3);
                    }
                }
                this.crystal = true;
            }
            for (int x2 = x - 1; x2 < x + 2; ++x2) {
                for (int y2 = y - 1; y2 < y + 2; ++y2) {
                    for (int z2 = z - 1; z2 < z + 2; ++z2) {
                        BlockPos pos2 = new BlockPos(x2, y2, z2);
                        Block block = world.func_180495_p(pos2).func_177230_c();
                        if (block != Blocks.field_150432_aD && block != Blocks.field_150433_aE && (block != Blocks.field_150431_aC || y2 == y - 1) || (x2 - 1 != x || world.func_180495_p(pos2.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos2.func_177976_e()).func_177230_c().func_149688_o() != Material.field_151586_h) && (x2 + 1 != x || world.func_180495_p(pos2.func_177974_f()).func_177230_c() != this && world.func_180495_p(pos2.func_177974_f()).func_177230_c().func_149688_o() != Material.field_151586_h) && (y2 - 1 != y || world.func_180495_p(pos2.func_177977_b()).func_177230_c() != this && world.func_180495_p(pos2.func_177977_b()).func_177230_c().func_149688_o() != Material.field_151586_h) && (y2 + 1 != y || world.func_180495_p(pos2.func_177984_a()).func_177230_c() != this && world.func_180495_p(pos2.func_177984_a()).func_177230_c().func_149688_o() != Material.field_151586_h) && (z2 - 1 != z || world.func_180495_p(pos2.func_177978_c()).func_177230_c() != this && world.func_180495_p(pos2.func_177978_c()).func_177230_c().func_149688_o() != Material.field_151586_h) && (z2 + 1 != z || world.func_180495_p(pos2.func_177968_d()).func_177230_c() != this && world.func_180495_p(pos2.func_177968_d()).func_177230_c().func_149688_o() != Material.field_151586_h)) continue;
                        this.crystal = false;
                        world.func_175684_a(pos, (Block)this, 5);
                        if (rand.nextInt(20) != 0) continue;
                        if (block == Blocks.field_150432_aD || block == Blocks.field_150433_aE) {
                            world.func_180501_a(pos2, Blocks.field_150355_j.func_176223_P(), 3);
                            this.crystal = true;
                        }
                        if (block != Blocks.field_150431_aC || y2 == y - 1) continue;
                        world.func_175698_g(pos2);
                        this.crystal = true;
                    }
                }
            }
        }
    }

    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151677_p;
    }

    public static enum EnumType implements IStringSerializable
    {
        DEFAULT(0, "default"),
        BLOCKCHISELED(1, "block_chiseled"),
        LINES_Y(2, "lines_y"),
        LINES_X(3, "lines_x"),
        LINES_Z(4, "lines_z"),
        BRICK(5, "brick"),
        BLOCKCRACKED(6, "block_cracked"),
        BRICKCRACKED(7, "brick_cracked"),
        BRICKCHISELED(8, "brick_chiseled"),
        CHAPITER(9, "chapiter");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

