/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.saltmod.block;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.saltmod.common.AchievSalt;
import ru.liahim.saltmod.common.ModBlocks;
import ru.liahim.saltmod.common.ModItems;

public class SaltCrystal
extends BlockBush {
    public static final PropertyEnum STAGE = PropertyEnum.func_177709_a((String)"stage", EnumType.class);
    protected boolean silkdrop = false;

    public SaltCrystal(String name, CreativeTabs tab) {
        this.func_149663_c(name);
        this.func_149647_a(tab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)((Object)EnumType.BIG)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)STAGE))).getMetadata();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{STAGE});
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        int meta = world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos));
        float g = 0.1875f;
        float v = 0.375f;
        if (meta == 1) {
            v = 0.625f;
        }
        if (meta == 2) {
            v = 0.875f;
        }
        this.func_149676_a(0.0f + g, 0.0f, 0.0f + g, 1.0f - g, 1.0f - v, 1.0f - g);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return this.func_180671_f(world, pos, world.func_180495_p(pos));
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        return World.func_175683_a((IBlockAccess)world, (BlockPos)pos.func_177977_b());
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        int silk = EnchantmentHelper.func_77506_a((int)Enchantment.field_77348_q.field_77352_x, (ItemStack)player.func_71045_bC());
        if (!world.field_72995_K) {
            if (player.func_71045_bC() != null && silk > 0) {
                this.silkdrop = true;
            }
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.saltOre) {
                this.crystalFind(world, pos, player);
            }
            if (world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos)) == 0 && (world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.saltBlock || world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.saltSlabDouble)) {
                player.func_71064_a((StatBase)AchievSalt.saltFarm, 1);
            }
        }
    }

    protected void crystalFind(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_73011_w.func_177502_q() == 0 && pos.func_177956_o() < 40) {
            player.func_71064_a((StatBase)AchievSalt.saltCrystal, 1);
        }
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        if (state.func_177230_c().func_176201_c(state) == 0) {
            if (this.silkdrop) {
                drop.add(new ItemStack((Block)this));
            } else {
                drop.add(new ItemStack(ModItems.saltPinch));
            }
        }
        this.silkdrop = false;
        return drop;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K) {
            if (entity instanceof EntityLivingBase && EntityList.func_75621_b((Entity)entity) != null && (EntityList.func_75621_b((Entity)entity).toLowerCase().contains("slime") && !EntityList.func_75621_b((Entity)entity).toLowerCase().contains("lava") || EntityList.func_75621_b((Entity)entity).toLowerCase().contains("witch"))) {
                entity.func_70097_a(DamageSource.field_76367_g, 30.0f);
                world.func_72908_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, "dig.glass", 1.0f, 2.0f);
                world.func_175655_b(pos, true);
            } else if (entity instanceof EntityPlayer && world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.saltOre) {
                this.crystalFind(world, pos, (EntityPlayer)entity);
            }
        }
    }

    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151660_b;
    }

    public static enum EnumType implements IStringSerializable
    {
        BIG(0, "sise_b"),
        MEDIUM(1, "sise_m"),
        SMALL(2, "sise_s");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

