/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.saltmod.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.saltmod.common.AchievSalt;

public class SaltDirt
extends Block {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public SaltDirt(CreativeTabs tab) {
        super(Material.field_151578_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.DEFAULT)));
        this.func_149675_a(true);
        this.func_149672_a(field_149767_g);
        this.func_149647_a(tab);
        this.func_149711_c(0.5f);
        this.func_149752_b(1.0f);
        this.setHarvestLevel("shovel", 0);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (meta == EnumType.LAKE.getMetadata()) {
            return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.LAKE));
        }
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.DEFAULT));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, EnumType.LAKE.getMetadata()));
        list.add(new ItemStack(item, 1, EnumType.DEFAULT.getMetadata()));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VARIANT});
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.func_180495_p(pos).func_177230_c().func_176201_c(worldIn.func_180495_p(pos)) == 1) {
            this.saltDamage(worldIn, entityIn);
            super.func_176199_a(worldIn, pos, entityIn);
        }
    }

    private void saltDamage(World worldIn, Entity entity) {
        if (entity instanceof EntityLivingBase && EntityList.func_75621_b((Entity)entity) != null && (EntityList.func_75621_b((Entity)entity).toLowerCase().contains("slime") && !EntityList.func_75621_b((Entity)entity).toLowerCase().contains("lava") || EntityList.func_75621_b((Entity)entity).toLowerCase().contains("witch"))) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_71064_a((StatBase)AchievSalt.saltLake, 1);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            if (world.func_180495_p(pos).func_177230_c().func_176201_c(world.func_180495_p(pos)) == 1 && (world.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o() == Material.field_151596_z || world.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o() == Material.field_151588_w)) {
                world.func_180501_a(pos.func_177984_a(), Blocks.field_150355_j.func_176223_P(), 3);
            }
            if (world.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o() == Material.field_151597_y) {
                world.func_175698_g(pos.func_177984_a());
            }
        }
    }

    public MapColor func_180659_g(IBlockState state) {
        MapColor color = MapColor.field_151664_l;
        if (state.func_177230_c().func_176201_c(state) == 1) {
            color = MapColor.field_151677_p;
        }
        return color;
    }

    public static enum EnumType implements IStringSerializable
    {
        DEFAULT(0, "default"),
        LAKE(1, "lake");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

