/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.saltmod.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.saltmod.common.ModBlocks;

public class SaltGrass
extends Block {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public SaltGrass(String name, CreativeTabs tab) {
        super(Material.field_151577_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.EMPTY)));
        this.func_149675_a(true);
        this.func_149647_a(tab);
        this.func_149672_a(field_149779_h);
        this.func_149663_c(name);
        this.func_149711_c(0.5f);
        this.func_149752_b(1.0f);
        this.setHarvestLevel("shovel", 0);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VARIANT});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180644_h(IBlockState state) {
        return this.func_149635_D();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        return renderPass == 1 ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT_MIPPED;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            if (world.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o() == Material.field_151597_y) {
                world.func_175698_g(pos.func_177984_a());
            }
            if (world.func_175671_l(pos.func_177984_a()) < 4 && world.getBlockLightOpacity(pos.func_177984_a()) > 2) {
                int j = world.func_180495_p(pos).func_177230_c().func_176201_c(state);
                world.func_180501_a(pos, ModBlocks.saltDirtLite.func_176203_a(j), 3);
            } else if (world.func_175671_l(pos.func_177984_a()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos pos2 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    IBlockState state2 = world.func_180495_p(pos2);
                    if (state2.func_177230_c() != Blocks.field_150346_d || state2.func_177229_b((IProperty)BlockDirt.field_176386_a) != BlockDirt.DirtType.DIRT || world.func_175671_l(pos2.func_177984_a()) < 4 || world.getBlockLightOpacity(pos2.func_177984_a()) > 2) continue;
                    world.func_175656_a(pos2, Blocks.field_150349_c.func_176223_P());
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return ModBlocks.saltDirtLite.func_180660_a(ModBlocks.saltDirtLite.func_176223_P(), random, fortune);
    }

    public static enum EnumType implements IStringSerializable
    {
        EMPTY(0, "empty"),
        EMPTY_1(1, "empty_1"),
        EMPTY_2(2, "empty_2"),
        SIDE_CNE(3, "side_cne"),
        SIDE_CES(4, "side_ces"),
        SIDE_CSW(5, "side_csw"),
        SIDE_CWN(6, "side_cwn"),
        SIDE_N(7, "side_n"),
        SIDE_E(8, "side_e"),
        SIDE_S(9, "side_s"),
        SIDE_W(10, "side_w"),
        SIDE_NE(11, "side_ne"),
        SIDE_ES(12, "side_es"),
        SIDE_SW(13, "side_sw"),
        SIDE_WN(14, "side_wn"),
        SIDE_NESW(15, "side_nesw");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta == 1 || meta == 2 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

