/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.saltmod.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.saltmod.common.AchievSalt;
import ru.liahim.saltmod.common.ModItems;

public class SaltLake
extends Block {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public SaltLake(String name, CreativeTabs tab) {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.CLEAR)));
        this.func_149675_a(true);
        this.func_149663_c(name);
        this.func_149647_a(tab);
        this.func_149711_c(3.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 1);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{VARIANT});
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.saltDamage(worldIn, entityIn);
        super.func_176199_a(worldIn, pos, entityIn);
    }

    private void saltDamage(World worldIn, Entity entity) {
        if (entity instanceof EntityLivingBase && EntityList.func_75621_b((Entity)entity) != null && (EntityList.func_75621_b((Entity)entity).toLowerCase().contains("slime") && !EntityList.func_75621_b((Entity)entity).toLowerCase().contains("lava") || EntityList.func_75621_b((Entity)entity).toLowerCase().contains("witch"))) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_71064_a((StatBase)AchievSalt.saltLake, 1);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            if (world.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o() == Material.field_151597_y) {
                world.func_175698_g(pos.func_177984_a());
            } else if (world.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o() == Material.field_151596_z || world.func_180495_p(pos.func_177984_a()).func_177230_c().func_149688_o() == Material.field_151588_w) {
                world.func_180501_a(pos.func_177984_a(), Blocks.field_150355_j.func_176223_P(), 3);
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return ModItems.salt;
    }

    public int func_149745_a(Random random) {
        return 1 + random.nextInt(3);
    }

    public int func_149679_a(int fortune, Random random) {
        if (fortune > 0) {
            int j = random.nextInt(fortune + 1);
            if (j > 2) {
                j = 2;
                return 2;
            }
            return this.func_149745_a(random) + j;
        }
        return this.func_149745_a(random);
    }

    public int getExpDrop(IBlockAccess world, BlockPos pos, int fortune) {
        return 1;
    }

    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151677_p;
    }

    public static enum EnumType implements IStringSerializable
    {
        CLEAR(0, "clear"),
        SIDE_N(1, "side_n"),
        SIDE_E(2, "side_e"),
        SIDE_NE(3, "side_ne"),
        SIDE_S(4, "side_s"),
        SIDE_NS(5, "side_ns"),
        SIDE_ES(6, "side_es"),
        SIDE_NES(7, "side_nes"),
        SIDE_W(8, "side_w"),
        SIDE_WN(9, "side_wn"),
        SIDE_WE(10, "side_we"),
        SIDE_WNE(11, "side_wne"),
        SIDE_SW(12, "side_sw"),
        SIDE_SWN(13, "side_swn"),
        SIDE_ESW(14, "side_esw"),
        SIDE_NESW(15, "side_nesw");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

