/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.saltmod.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.saltmod.common.CommonProxy;
import ru.liahim.saltmod.common.ModBlocks;

public abstract class SaltSlab
extends BlockSlab {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    protected boolean crystal = true;

    public SaltSlab(String name) {
        super(Material.field_151576_e);
        CreativeTabs tab = null;
        IBlockState iblockstate = this.field_176227_L.func_177621_b();
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
            tab = CommonProxy.saltTab;
        }
        this.func_180632_j(iblockstate.func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.BLOCK)));
        this.func_149675_a(true);
        this.func_149663_c(name);
        this.func_149647_a(tab);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.field_149783_u = !this.func_176552_j();
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a() + "." + EnumType.byMetadata(meta).getUnlocalizedName();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.saltSlab);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_180665_b(World worldIn, BlockPos pos) {
        return Item.func_150898_a((Block)ModBlocks.saltSlab);
    }

    public IProperty func_176551_l() {
        return VARIANT;
    }

    public Object func_176553_a(ItemStack stack) {
        return EnumType.byMetadata(stack.func_77960_j() & 7);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        if (itemIn != Item.func_150898_a((Block)ModBlocks.saltSlabDouble)) {
            for (EnumType type : EnumType.values()) {
                list.add(new ItemStack(itemIn, 1, type.getMetadata()));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)EnumType.byMetadata(meta & 7)));
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
        if (!this.func_176552_j() && state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    protected BlockState func_180661_e() {
        return this.func_176552_j() ? new BlockState((Block)this, new IProperty[]{VARIANT}) : new BlockState((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b((IProperty)VARIANT))).getMetadata();
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.saltDamage(worldIn, entityIn);
        super.func_176199_a(worldIn, pos, entityIn);
    }

    private void saltDamage(World worldIn, Entity entity) {
        if (entity instanceof EntityLivingBase && EntityList.func_75621_b((Entity)entity) != null && (EntityList.func_75621_b((Entity)entity).toLowerCase().contains("slime") && !EntityList.func_75621_b((Entity)entity).toLowerCase().contains("lava") || EntityList.func_75621_b((Entity)entity).toLowerCase().contains("witch"))) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            int yDOWN;
            int yUP;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            BlockPos posUp = new BlockPos((Vec3i)pos.func_177984_a());
            if (!(world.func_180495_p(posUp.func_177974_f()).func_177230_c() != ModBlocks.saltBlock && world.func_180495_p(posUp.func_177974_f()).func_177230_c() != ModBlocks.saltSlabDouble || world.func_180495_p(posUp.func_177976_e()).func_177230_c() != ModBlocks.saltBlock && world.func_180495_p(posUp.func_177976_e()).func_177230_c() != ModBlocks.saltSlabDouble || world.func_180495_p(posUp.func_177978_c()).func_177230_c() != ModBlocks.saltBlock && world.func_180495_p(posUp.func_177978_c()).func_177230_c() != ModBlocks.saltSlabDouble || world.func_180495_p(posUp.func_177968_d()).func_177230_c() != ModBlocks.saltBlock && world.func_180495_p(posUp.func_177968_d()).func_177230_c() != ModBlocks.saltSlabDouble || world.func_180495_p(posUp.func_177982_a(1, 0, 1)).func_177230_c().func_149688_o() != Material.field_151586_h || world.func_180495_p(posUp.func_177982_a(1, 0, -1)).func_177230_c().func_149688_o() != Material.field_151586_h || world.func_180495_p(posUp.func_177982_a(-1, 0, 1)).func_177230_c().func_149688_o() != Material.field_151586_h || world.func_180495_p(posUp.func_177982_a(-1, 0, -1)).func_177230_c().func_149688_o() != Material.field_151586_h || world.func_175671_l(posUp) >= 15)) {
                if (rand.nextInt(CommonProxy.saltCrystalGrowSpeed) == 0 && this.crystal) {
                    if (world.func_175623_d(posUp)) {
                        world.func_180501_a(posUp, ModBlocks.saltCrystal.func_176203_a(2), 3);
                    } else if (world.func_180495_p(posUp).func_177230_c() == ModBlocks.saltCrystal && world.func_180495_p(posUp).func_177230_c().func_176201_c(world.func_180495_p(posUp)) == 2) {
                        world.func_180501_a(posUp, ModBlocks.saltCrystal.func_176203_a(1), 3);
                    } else if (world.func_180495_p(posUp).func_177230_c() == ModBlocks.saltCrystal && world.func_180495_p(posUp).func_177230_c().func_176201_c(world.func_180495_p(posUp)) == 1) {
                        world.func_180501_a(posUp, ModBlocks.saltCrystal.func_176223_P(), 3);
                    }
                }
                this.crystal = true;
            }
            if (this == ModBlocks.saltSlabDouble) {
                yUP = 2;
                yDOWN = 1;
            } else if (World.func_175683_a((IBlockAccess)world, (BlockPos)pos)) {
                yUP = 2;
                yDOWN = 0;
            } else {
                yUP = 1;
                yDOWN = 1;
            }
            for (int x2 = x - 1; x2 < x + 2; ++x2) {
                for (int y2 = y - yDOWN; y2 < y + yUP; ++y2) {
                    for (int z2 = z - 1; z2 < z + 2; ++z2) {
                        BlockPos pos2 = new BlockPos(x2, y2, z2);
                        Block block = world.func_180495_p(pos2).func_177230_c();
                        if (block != Blocks.field_150432_aD && block != Blocks.field_150433_aE && (block != Blocks.field_150431_aC || y2 == y - 1 || yDOWN != 1) || (x2 - 1 != x || world.func_180495_p(pos2.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos2.func_177976_e()).func_177230_c().func_149688_o() != Material.field_151586_h) && (x2 + 1 != x || world.func_180495_p(pos2.func_177974_f()).func_177230_c() != this && world.func_180495_p(pos2.func_177974_f()).func_177230_c().func_149688_o() != Material.field_151586_h) && (y2 - 1 != y || world.func_180495_p(pos2.func_177977_b()).func_177230_c() != this && world.func_180495_p(pos2.func_177977_b()).func_177230_c().func_149688_o() != Material.field_151586_h) && (y2 + 1 != y || world.func_180495_p(pos2.func_177984_a()).func_177230_c() != this && world.func_180495_p(pos2.func_177984_a()).func_177230_c().func_149688_o() != Material.field_151586_h) && (z2 - 1 != z || world.func_180495_p(pos2.func_177978_c()).func_177230_c() != this && world.func_180495_p(pos2.func_177978_c()).func_177230_c().func_149688_o() != Material.field_151586_h) && (z2 + 1 != z || world.func_180495_p(pos2.func_177968_d()).func_177230_c() != this && world.func_180495_p(pos2.func_177968_d()).func_177230_c().func_149688_o() != Material.field_151586_h)) continue;
                        this.crystal = false;
                        world.func_175684_a(pos, (Block)this, 5);
                        if (rand.nextInt(20) != 0) continue;
                        if (block == Blocks.field_150432_aD || block == Blocks.field_150433_aE) {
                            world.func_180501_a(pos2, Blocks.field_150355_j.func_176223_P(), 3);
                            this.crystal = true;
                        }
                        if (block != Blocks.field_150431_aC || y2 == y - 1) continue;
                        world.func_175698_g(pos2);
                        this.crystal = true;
                    }
                }
            }
        }
    }

    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151677_p;
    }

    public static enum EnumType implements IStringSerializable
    {
        BLOCK(0, "block", "Block"),
        BRICK(1, "brick", "Brick"),
        PILLAR(2, "pillar", "Pillar");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        private EnumType(int meta, String name, String unlocalizedName) {
            this.meta = meta;
            this.name = name;
            this.unlocalizedName = unlocalizedName;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

