/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.saltmod.extractor;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.saltmod.SaltMod;
import ru.liahim.saltmod.common.ModBlocks;
import ru.liahim.saltmod.extractor.TileEntityExtractor;

public class Extractor
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private final boolean isBurning;
    private final boolean isExtract;
    private static boolean keepInventory;

    public Extractor(boolean burn, boolean ext, String name, CreativeTabs tab) {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.isBurning = burn;
        this.isExtract = ext;
        this.func_149663_c(name);
        this.func_149647_a(tab);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.extractor);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            Block block = worldIn.func_180495_p(pos.func_177978_c()).func_177230_c();
            Block block1 = worldIn.func_180495_p(pos.func_177968_d()).func_177230_c();
            Block block2 = worldIn.func_180495_p(pos.func_177976_e()).func_177230_c();
            Block block3 = worldIn.func_180495_p(pos.func_177974_f()).func_177230_c();
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && block.func_149730_j() && !block1.func_149730_j()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_149730_j() && !block.func_149730_j()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_149730_j() && !block3.func_149730_j()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_149730_j() && !block2.func_149730_j()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.isBurning) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double d5 = (double)pos.func_177958_n() + rand.nextDouble() * (double)0.4f + (double)0.3f;
            double d6 = (double)pos.func_177952_p() + rand.nextDouble() * (double)0.4f + (double)0.3f;
            double d7 = (double)pos.func_177958_n() + (double)rand.nextFloat();
            double d8 = (double)pos.func_177952_p() + (double)rand.nextFloat();
            boolean clear = !worldIn.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN);
            boolean ceiling = worldIn.isSideSolid(pos.func_177981_b(2), EnumFacing.DOWN);
            switch (SwitchEnumFacing.FACING_LOOKUP[enumfacing.ordinal()]) {
                case 1: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case 2: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case 3: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case 4: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            if (this.isExtract && clear) {
                worldIn.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, d5, (double)pos.func_177956_o() + 1.1, d6, 0.0, 0.1, 0.0, new int[0]);
                if (ceiling && rand.nextInt(10) == 0) {
                    worldIn.func_175688_a(EnumParticleTypes.DRIP_WATER, d7, (double)pos.func_177956_o() + 1.95, d8, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntityExtractor te = (TileEntityExtractor)worldIn.func_175625_s(pos);
        if (te != null && !Extractor.fillTank(worldIn, pos, te, itemstack = playerIn.field_71071_by.func_70448_g(), playerIn) && !this.drainTank(worldIn, pos, te, itemstack, playerIn)) {
            playerIn.openGui((Object)SaltMod.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public static boolean fillTank(World worldIn, BlockPos pos, IFluidHandler tank, ItemStack held, EntityPlayer playerIn) {
        if (held != null) {
            int used;
            FluidStack heldContents = FluidContainerRegistry.getFluidForFilledItem((ItemStack)held);
            if (heldContents != null && held.func_77973_b() != Items.field_151068_bn) {
                int used2 = tank.fill(EnumFacing.UP, heldContents, true);
                if (used2 > 0) {
                    ItemStack consumed = held.func_77973_b().getContainerItem(held);
                    if (consumed != null && !playerIn.field_71075_bZ.field_75098_d) {
                        Extractor.playerInvChange(worldIn, pos, held, playerIn, consumed);
                    }
                    return true;
                }
            } else if (held.func_77973_b() == Items.field_151068_bn && (used = tank.fill(EnumFacing.UP, heldContents = new FluidStack(FluidRegistry.WATER, 333), true)) > 0) {
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    Extractor.playerInvChange(worldIn, pos, held, playerIn, new ItemStack(Items.field_151069_bo));
                }
                return true;
            }
        }
        return false;
    }

    private boolean drainTank(World worldIn, BlockPos pos, IFluidHandler tank, ItemStack held, EntityPlayer playerIn) {
        if (held != null) {
            FluidStack heldContents = FluidContainerRegistry.getFluidForFilledItem((ItemStack)held);
            FluidStack available = tank.drain(EnumFacing.UP, Integer.MAX_VALUE, false);
            if (available != null) {
                ItemStack filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)held);
                heldContents = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled);
                if (available.getFluid() == FluidRegistry.WATER && held.func_77973_b() == Items.field_151069_bo && available.amount >= 333) {
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        Extractor.playerInvChange(worldIn, pos, held, playerIn, new ItemStack((Item)Items.field_151068_bn));
                    }
                    tank.drain(EnumFacing.UP, 333, true);
                    return true;
                }
                if (heldContents != null) {
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        Extractor.playerInvChange(worldIn, pos, held, playerIn, filled);
                    }
                    tank.drain(EnumFacing.UP, heldContents.amount, true);
                    return true;
                }
            }
        }
        return false;
    }

    private static void playerInvChange(World worldIn, BlockPos pos, ItemStack held, EntityPlayer playerIn, ItemStack stack) {
        if (--held.field_77994_a <= 0) {
            playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, (ItemStack)null);
        }
        if (playerIn.field_71071_by.func_70448_g() != null) {
            if (!playerIn.field_71071_by.func_70441_a(stack)) {
                worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, stack));
            } else if (playerIn instanceof EntityPlayerMP) {
                ((EntityPlayerMP)playerIn).func_71120_a(playerIn.field_71069_bz);
            }
        } else {
            playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, stack);
            if (playerIn instanceof EntityPlayerMP) {
                ((EntityPlayerMP)playerIn).func_71120_a(playerIn.field_71069_bz);
            }
        }
    }

    public static void setState(boolean active, boolean extract, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        keepInventory = true;
        if (active) {
            if (extract) {
                worldIn.func_180501_a(pos, ModBlocks.extractorSteam.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
                worldIn.func_180501_a(pos, ModBlocks.extractorSteam.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
            } else {
                worldIn.func_180501_a(pos, ModBlocks.extractorLit.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
                worldIn.func_180501_a(pos, ModBlocks.extractorLit.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
            }
        } else {
            worldIn.func_180501_a(pos, ModBlocks.extractor.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
            worldIn.func_180501_a(pos, ModBlocks.extractor.func_176223_P().func_177226_a((IProperty)FACING, iblockstate.func_177229_b((IProperty)FACING)), 3);
        }
        keepInventory = false;
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityExtractor();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack.func_82837_s() && (te = worldIn.func_175625_s(pos)) instanceof TileEntityExtractor) {
            ((TileEntityExtractor)te).setCustomInventoryName(stack.func_82833_r());
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (!keepInventory && (te = worldIn.func_175625_s(pos)) instanceof TileEntityExtractor) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityExtractor)te));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World worldIn, BlockPos pos) {
        TileEntityExtractor te = (TileEntityExtractor)worldIn.func_175625_s(pos);
        return te.tank.getFluid() != null ? te.getFluidAmountScaled(15) : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_180665_b(World worldIn, BlockPos pos) {
        return Item.func_150898_a((Block)ModBlocks.extractor);
    }

    public int func_149645_b() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState func_176217_b(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }

    @SideOnly(value=Side.CLIENT)
    static final class SwitchEnumFacing {
        static final int[] FACING_LOOKUP = new int[EnumFacing.values().length];

        SwitchEnumFacing() {
        }

        static {
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.WEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.EAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.SOUTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

