/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.saltmod.extractor;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import ru.liahim.saltmod.api.ExtractRegistry;
import ru.liahim.saltmod.common.CommonProxy;
import ru.liahim.saltmod.extractor.ContainerExtractor;
import ru.liahim.saltmod.extractor.ExtractorButtonMessage;
import ru.liahim.saltmod.extractor.GuiExtractorButton;
import ru.liahim.saltmod.extractor.TileEntityExtractor;

@SideOnly(value=Side.CLIENT)
public class GuiExtractor
extends GuiContainer {
    private static final ResourceLocation guiTextures = new ResourceLocation("saltmod:textures/gui/container/extraktor.png");
    private final InventoryPlayer playerInventory;
    private IInventory tileExtractor;
    private static final int maxCap = 1000 * CommonProxy.extractorVolume;
    private GuiExtractorButton button;

    public GuiExtractor(InventoryPlayer playerInv, IInventory extractorInv) {
        super((Container)new ContainerExtractor(playerInv, extractorInv));
        this.playerInventory = playerInv;
        this.tileExtractor = extractorInv;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.button = new GuiExtractorButton(guiTextures, 1, this.field_147003_i + 97, this.field_147009_r + 16);
        this.field_146292_n.add(this.button);
        this.button.field_146124_l = false;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.button.field_146124_l = this.tileExtractor.func_174887_a_(4) > 0;
    }

    protected void func_146284_a(GuiButton button) {
        BlockPos pos = ((TileEntity)this.tileExtractor).func_174877_v();
        CommonProxy.network.sendToServer((IMessage)new ExtractorButtonMessage(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
    }

    protected void func_146979_b(int par_1, int par_2) {
        String s = this.tileExtractor.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2 - 10, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float par_1, int par_2, int par_3) {
        int i1;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        if (TileEntityExtractor.isBurning(this.tileExtractor)) {
            i1 = this.getBurnTimeRemainingScaled(13);
            this.func_73729_b(k + 71, l + 54 + 12 - i1, 176, 12 - i1, 14, i1 + 1);
        }
        if (this.tileExtractor.func_174887_a_(4) > 0) {
            i1 = this.getExtractProgressScaled(17);
            this.func_73729_b(k + 96, l + 36, 176, 14, i1 + 1, 10);
        }
        if (this.tileExtractor.func_174887_a_(5) > 0) {
            i1 = this.tileExtractor.func_174887_a_(5);
            this.func_73729_b(k + 59, l + 32 - i1, 176, 40 - i1, 1, i1);
        }
        if (this.getFluidAmountScaled(32) > 0) {
            this.drawTank(k, l, 62, 17, 32, this.getFluidAmountScaled(32), this.tileExtractor.func_174887_a_(3));
            this.field_146297_k.func_110434_K().func_110577_a(guiTextures);
        }
    }

    public int getExtractProgressScaled(int scale) {
        int vol = ExtractRegistry.instance().getExtractFluidVolum(FluidRegistry.getFluid((int)this.tileExtractor.func_174887_a_(3)));
        if (vol == 0) {
            vol = 1000;
        }
        return this.tileExtractor.func_174887_a_(2) * scale / vol;
    }

    public int getBurnTimeRemainingScaled(int scale) {
        int time = this.tileExtractor.func_174887_a_(1);
        if (time == 0) {
            time = 200;
        }
        return this.tileExtractor.func_174887_a_(0) * scale / time;
    }

    public int getFluidAmountScaled(int scale) {
        return MathHelper.func_76123_f((float)((float)this.tileExtractor.func_174887_a_(4) * (float)scale / (float)maxCap));
    }

    protected void drawTank(int w, int h, int wp, int hp, int width, int amount, int fluidID) {
        if (fluidID == 0) {
            return;
        }
        Fluid fluid = FluidRegistry.getFluid((int)fluidID);
        int color = fluid.getColor();
        ResourceLocation fluidTexture = fluid.getStill();
        TextureAtlasSprite sprite = this.field_146297_k.func_147117_R().func_110572_b(fluidTexture.toString());
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        this.func_175175_a(w + wp, h + hp + 32 - amount, sprite, width, amount);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ArrayList<String> toolTip;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        if (mouseX >= w + 62 && mouseY >= h + 17 && mouseX < w + 62 + 32 && mouseY < h + 17 + 32) {
            toolTip = new ArrayList<String>();
            if (this.tileExtractor.func_174887_a_(4) > 0) {
                toolTip.add(new FluidStack(FluidRegistry.getFluid((int)this.tileExtractor.func_174887_a_(3)), this.tileExtractor.func_174887_a_(4)).getLocalizedName());
            }
            this.drawText(toolTip, mouseX, mouseY, this.field_146289_q);
        }
        if (mouseX >= w + 97 && mouseY >= h + 16 && mouseX < w + 97 + 3 && mouseY < h + 16 + 3) {
            toolTip = new ArrayList();
            if (this.tileExtractor.func_174887_a_(4) > 0) {
                toolTip.add(I18n.func_135052_a((String)"container.discard", (Object[])new Object[0]));
            }
            this.drawText(toolTip, mouseX, mouseY, this.field_146289_q);
        }
    }

    protected void drawText(List list, int par2, int par3, FontRenderer font) {
        if (!list.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : list) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (list.size() > 1) {
                k1 += 2 + (list.size() - 1) * 10;
            }
            if (i1 + k > this.field_146294_l) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_146295_m) {
                j1 = this.field_146295_m - k1 - 6;
            }
            this.field_73735_i = 300.0f;
            this.field_146296_j.field_77023_b = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < list.size(); ++k2) {
                String s1 = (String)list.get(k2);
                font.func_175063_a(s1, (float)i1, (float)j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            this.field_146296_j.field_77023_b = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }
}

