/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.saltmod.extractor;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.saltmod.api.ExtractRegistry;
import ru.liahim.saltmod.common.CommonProxy;
import ru.liahim.saltmod.extractor.ContainerExtractor;
import ru.liahim.saltmod.extractor.Extractor;

public class TileEntityExtractor
extends TileEntityLockable
implements ITickable,
ISidedInventory,
IFluidHandler {
    private static final int[] slotsBottom = new int[]{0, 1};
    private static final int[] slotsSides = new int[]{1};
    private ItemStack[] invSlots = new ItemStack[2];
    public int burningTime;
    public int currentItemBurnTime;
    public int extractTime;
    public int liquidID;
    public int liquidLevel;
    private String inventoryName;
    private int liquidChange;
    private int redSS;
    private int steamLevel;
    private int steamTime;
    public int pressure;
    private static final int maxCap = 1000 * CommonProxy.extractorVolume;
    public FluidTank tank = new FluidTank(maxCap);

    public void func_73660_a() {
        boolean clear;
        boolean burn = this.burningTime > 0;
        boolean teUpdate = false;
        boolean bl = clear = !this.field_145850_b.isSideSolid(this.field_174879_c.func_177984_a(), EnumFacing.DOWN);
        if (this.liquidLevel > 0 && this.liquidChange == 0) {
            this.liquidChange = this.liquidLevel;
            teUpdate = true;
            if (this.canExtract()) {
                Extractor.setState(this.burningTime > 0, true, this.field_145850_b, this.field_174879_c);
            }
        }
        if (this.liquidLevel == 0 && this.liquidChange > 0) {
            this.liquidChange = 0;
            this.extractTime = 0;
            teUpdate = true;
            Extractor.setState(this.burningTime > 0, false, this.field_145850_b, this.field_174879_c);
        }
        if (this.burningTime > 0) {
            --this.burningTime;
        }
        if (this.liquidChange != this.liquidLevel && this.redSS != this.getFluidAmountScaled(15)) {
            this.liquidChange = this.liquidLevel;
            this.redSS = this.getFluidAmountScaled(15);
            teUpdate = true;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.liquidID = this.tank.getFluid() != null ? FluidRegistry.getFluidID((Fluid)this.tank.getFluid().getFluid()) : 0;
            int n = this.liquidLevel = this.tank.getFluid() != null ? this.tank.getFluidAmount() : 0;
            if (this.burningTime != 0 || this.invSlots[1] != null && !this.isFluidTankEmpty()) {
                if (this.burningTime == 0 && this.canExtract()) {
                    this.currentItemBurnTime = this.burningTime = TileEntityFurnace.func_145952_a((ItemStack)this.invSlots[1]);
                    if (this.burningTime > 0) {
                        teUpdate = true;
                        if (this.invSlots[1] != null) {
                            --this.invSlots[1].field_77994_a;
                            if (this.invSlots[1].field_77994_a == 0) {
                                this.invSlots[1] = this.invSlots[1].func_77973_b().getContainerItem(this.invSlots[1]);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canExtract()) {
                    if (clear) {
                        int vol = ExtractRegistry.instance().getExtractFluidVolum(this.tank.getFluid().getFluid());
                        ++this.extractTime;
                        if (this.extractTime == vol) {
                            this.extractTime = 0;
                            this.extract();
                            teUpdate = true;
                        }
                        this.tank.drain(1, true);
                    } else {
                        this.pressure();
                    }
                } else {
                    this.extractTime = 0;
                }
            }
            if (burn != this.burningTime > 0) {
                teUpdate = true;
                Extractor.setState(this.burningTime > 0, this.canExtract(), this.field_145850_b, this.field_174879_c);
            }
            if (this.steamLevel != 0 && clear || this.liquidLevel == 0 && !clear || !this.isBurning()) {
                this.pressure = 0;
                this.steamLevel = 0;
                this.steamTime = 0;
            }
        }
        if (teUpdate) {
            this.func_70296_d();
        }
    }

    public boolean isBurning() {
        return this.burningTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inv) {
        return inv.func_174887_a_(0) > 0;
    }

    public void pressure() {
        int vol = ExtractRegistry.instance().getExtractFluidVolum(this.tank.getFluid().getFluid());
        this.pressure = this.steamLevel / ((32 - this.getFluidAmountScaled(32) + 1) * 4);
        ++this.steamTime;
        if (this.steamTime % (this.pressure + 1) == 0) {
            ++this.extractTime;
            this.steamTime = 0;
            if (this.extractTime == vol) {
                this.extractTime = 0;
                this.extract();
                this.func_70296_d();
            }
            this.tank.drain(1, true);
        }
        ++this.steamLevel;
        if (this.pressure >= 16) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
            this.field_145850_b.func_72876_a((Entity)null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 2.5f, true);
        }
    }

    public boolean canExtract() {
        if (this.isFluidTankEmpty()) {
            return false;
        }
        ItemStack itemstack = ExtractRegistry.instance().getExtractItemStack(this.tank.getFluid().getFluid());
        if (itemstack == null) {
            return false;
        }
        if (this.invSlots[0] == null) {
            return true;
        }
        if (!this.invSlots[0].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.invSlots[0].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.invSlots[0].func_77976_d();
    }

    public void extract() {
        if (this.canExtract()) {
            ItemStack itemstack = ExtractRegistry.instance().getExtractItemStack(this.tank.getFluid().getFluid());
            if (this.invSlots[0] == null) {
                this.invSlots[0] = itemstack.func_77946_l();
            } else if (this.invSlots[0].func_77969_a(itemstack)) {
                this.invSlots[0].field_77994_a += itemstack.field_77994_a;
            }
        }
    }

    public ItemStack func_70301_a(int index) {
        return this.invSlots[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.invSlots[index] != null) {
            if (this.invSlots[index].field_77994_a <= count) {
                ItemStack itemstack = this.invSlots[index];
                this.invSlots[index] = null;
                return itemstack;
            }
            ItemStack itemstack = this.invSlots[index].func_77979_a(count);
            if (this.invSlots[index].field_77994_a == 0) {
                this.invSlots[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.invSlots[index] != null) {
            ItemStack itemstack = this.invSlots[index];
            this.invSlots[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.invSlots[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return this.invSlots.length;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 ? false : (index == 1 ? TileEntityFurnace.func_145954_b((ItemStack)stack) : false);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side != EnumFacing.UP ? slotsSides : new int[]{});
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction != EnumFacing.DOWN || index != 1 || stack.func_77973_b() == Items.field_151133_ar;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.inventoryName : "container.extractor";
    }

    public boolean func_145818_k_() {
        return this.inventoryName != null && this.inventoryName.length() > 0;
    }

    public void setCustomInventoryName(String string) {
        this.inventoryName = string;
    }

    public String func_174875_k() {
        return "saltmod:extractor";
    }

    public IChatComponent func_145748_c_() {
        return this.func_145818_k_() ? new ChatComponentText(this.func_70005_c_()) : new ChatComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerExtractor(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.burningTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.extractTime;
            }
            case 3: {
                return this.liquidID;
            }
            case 4: {
                return this.liquidLevel;
            }
            case 5: {
                return this.pressure;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.burningTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.extractTime = value;
                break;
            }
            case 3: {
                this.liquidID = value;
                break;
            }
            case 4: {
                this.liquidLevel = value;
                break;
            }
            case 5: {
                this.pressure = value;
            }
        }
    }

    public int func_174890_g() {
        return 6;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.invSlots.length; ++i) {
            this.invSlots[i] = null;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList inv_tags = nbt.func_150295_c("Items", 10);
        this.invSlots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < inv_tags.func_74745_c(); ++i) {
            NBTTagCompound tag = inv_tags.func_150305_b(i);
            byte b0 = tag.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.invSlots.length) continue;
            this.invSlots[b0] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.burningTime = nbt.func_74765_d("BurnTime");
        this.extractTime = nbt.func_74765_d("CookTime");
        this.currentItemBurnTime = nbt.func_74765_d("ItemBurnTime");
        this.steamLevel = nbt.func_74765_d("SteamLevel");
        this.readTankFromNBT(nbt);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.inventoryName = nbt.func_74779_i("CustomName");
        }
    }

    protected void readTankFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Tank")) {
            this.tank.readFromNBT(nbt.func_74775_l("Tank"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("BurnTime", (short)this.burningTime);
        nbt.func_74777_a("CookTime", (short)this.extractTime);
        nbt.func_74777_a("ItemBurnTime", (short)this.currentItemBurnTime);
        nbt.func_74777_a("SteamLevel", (short)this.steamLevel);
        NBTTagList taglist = new NBTTagList();
        for (int i = 0; i < this.invSlots.length; ++i) {
            if (this.invSlots[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            this.invSlots[i].func_77955_b(tag);
            taglist.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Items", (NBTBase)taglist);
        this.writeTankToNBT(nbt);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.inventoryName);
        }
    }

    protected void writeTankToNBT(NBTTagCompound nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        this.tank.writeToNBT(tag);
        nbt.func_74782_a("Tank", (NBTBase)tag);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int f = this.tank.fill(resource, doFill);
        return f;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        FluidStack d = this.tank.drain(maxDrain, doDrain);
        return d;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int getFluidAmountScaled(int scale) {
        return MathHelper.func_76123_f((float)((float)this.getFluidAmount() * (float)scale / (float)maxCap));
    }

    public boolean isFluidTankEmpty() {
        return this.getFluidAmount() == 0;
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }
}

