/*
 * Decompiled with CFR 0.152.
 */
package com.tommsy.smartmoving.client.model;

import com.tommsy.smartmoving.client.SmartMovingAbstractClientPlayer;
import com.tommsy.smartmoving.client.model.SmartMovingModelBiped;
import com.tommsy.smartmoving.client.renderer.ModelPreviousRotationRenderer;
import com.tommsy.smartmoving.client.renderer.ModelRotationRenderer;
import com.tommsy.smartmoving.client.renderer.ScaleType;
import com.tommsy.smartmoving.common.SmartMovingPlayerState;
import java.util.List;
import java.util.Random;
import lombok.NonNull;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class SmartMovingModelBipedHandler {
    private final SmartMovingModelBiped smModel;
    private final ModelBiped model;
    private final boolean doGLMatrixPop;
    protected ModelPreviousRotationRenderer bipedOuter;
    protected ModelRotationRenderer bipedTorso;
    protected ModelRotationRenderer bipedBody;
    protected ModelRotationRenderer bipedBreast;
    protected ModelRotationRenderer bipedNeck;
    protected ModelRotationRenderer bipedHead;
    protected ModelRotationRenderer bipedRightShoulder;
    protected ModelRotationRenderer bipedRightArm;
    protected ModelRotationRenderer bipedLeftShoulder;
    protected ModelRotationRenderer bipedLeftArm;
    protected ModelRotationRenderer bipedPelvic;
    protected ModelRotationRenderer bipedRightLeg;
    protected ModelRotationRenderer bipedLeftLeg;
    protected ModelRotationRenderer bipedHeadwear;
    public float rotationYaw;
    public boolean isBeingRenderedInInventory;
    @NonNull
    private ScaleType scaleArm = ScaleType.Scale;
    @NonNull
    private ScaleType scaleLeg = ScaleType.Scale;

    public SmartMovingModelBipedHandler(SmartMovingModelBiped smModel) {
        this(smModel, true);
    }

    protected SmartMovingModelBipedHandler(SmartMovingModelBiped smModel, boolean doGLMatrixPop) {
        this.smModel = smModel;
        this.model = this.smModel.getImplementation();
        this.doGLMatrixPop = doGLMatrixPop;
        this.model.field_78092_r.clear();
    }

    public final void initialize() {
        this.initializeRenderers();
        this.reset();
    }

    protected void initializeRenderers() {
        this.bipedOuter = new ModelPreviousRotationRenderer((ModelBase)this.model, -1, -1, null);
        this.bipedOuter.fadeEnabled = true;
        this.bipedTorso = new ModelRotationRenderer((ModelBase)this.model, this.bipedOuter);
        this.bipedBody = new ModelRotationRenderer((ModelBase)this.model, this.bipedTorso, this.model.field_78115_e);
        this.bipedBreast = new ModelRotationRenderer((ModelBase)this.model, this.bipedTorso);
        this.bipedNeck = new ModelRotationRenderer((ModelBase)this.model, this.bipedBreast);
        this.bipedHead = new ModelRotationRenderer((ModelBase)this.model, this.bipedNeck, this.model.field_78116_c);
        this.bipedRightShoulder = new ModelRotationRenderer((ModelBase)this.model, this.bipedBreast);
        this.bipedRightArm = new ModelRotationRenderer((ModelBase)this.model, this.bipedRightShoulder, this.model.field_178723_h);
        this.bipedLeftShoulder = new ModelRotationRenderer((ModelBase)this.model, this.bipedBreast);
        this.bipedLeftShoulder.field_78809_i = true;
        this.bipedLeftArm = new ModelRotationRenderer((ModelBase)this.model, this.bipedLeftShoulder, this.model.field_178724_i);
        this.bipedPelvic = new ModelRotationRenderer((ModelBase)this.model, this.bipedTorso);
        this.bipedRightLeg = new ModelRotationRenderer((ModelBase)this.model, this.bipedPelvic, this.model.field_178721_j);
        this.bipedLeftLeg = new ModelRotationRenderer((ModelBase)this.model, this.bipedPelvic, this.model.field_178722_k);
        this.bipedHeadwear = new ModelRotationRenderer((ModelBase)this.model, this.bipedHead, this.model.field_178720_f);
        this.model.field_78115_e = this.bipedBody;
        this.model.field_78116_c = this.bipedHead;
        this.model.field_178720_f = this.bipedHeadwear;
        this.model.field_178723_h = this.bipedRightArm;
        this.model.field_178724_i = this.bipedLeftArm;
        this.model.field_178721_j = this.bipedRightLeg;
        this.model.field_178722_k = this.bipedLeftLeg;
    }

    public void preRender(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GL11.glPushMatrix();
        this.bipedHeadwear.ignoreRender = true;
        this.bipedLeftLeg.ignoreRender = true;
        this.bipedRightLeg.ignoreRender = true;
        this.bipedLeftArm.ignoreRender = true;
        this.bipedRightArm.ignoreRender = true;
        this.bipedHead.ignoreRender = true;
        this.bipedBody.ignoreRender = true;
    }

    public void postRender(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.bipedHeadwear.ignoreRender = false;
        this.bipedLeftLeg.ignoreRender = false;
        this.bipedRightLeg.ignoreRender = false;
        this.bipedLeftArm.ignoreRender = false;
        this.bipedRightArm.ignoreRender = false;
        this.bipedHead.ignoreRender = false;
        this.bipedBody.ignoreRender = false;
        this.bipedOuter.func_78785_a(scale);
        this.bipedOuter.renderIgnoreBase(scale);
        this.bipedTorso.renderIgnoreBase(scale);
        this.bipedBody.renderIgnoreBase(scale);
        this.bipedBreast.renderIgnoreBase(scale);
        this.bipedNeck.renderIgnoreBase(scale);
        this.bipedHead.renderIgnoreBase(scale);
        this.bipedRightShoulder.renderIgnoreBase(scale);
        this.bipedRightArm.renderIgnoreBase(scale);
        this.bipedLeftShoulder.renderIgnoreBase(scale);
        this.bipedLeftArm.renderIgnoreBase(scale);
        this.bipedPelvic.renderIgnoreBase(scale);
        this.bipedRightLeg.renderIgnoreBase(scale);
        this.bipedLeftLeg.renderIgnoreBase(scale);
        this.bipedHeadwear.renderIgnoreBase(scale);
        this.popMatrix();
    }

    public boolean preSetRotationAngles(float totalHorizontalDistance, float currentHorizontalSpeed, float ageInTicks, float headYawAngle, float headPitchAngle, float scaleFactor, Entity entity) {
        float elytraMagnitude;
        this.reset();
        if (this.isBeingRenderedInInventory) {
            this.bipedBody.ignoreBase = true;
            this.bipedHead.ignoreBase = true;
            this.bipedRightArm.ignoreBase = true;
            this.bipedLeftArm.ignoreBase = true;
            this.bipedRightLeg.ignoreBase = true;
            this.bipedLeftLeg.ignoreBase = true;
            this.bipedBody.forceRender = false;
            this.bipedHead.forceRender = false;
            this.bipedRightArm.forceRender = false;
            this.bipedLeftArm.forceRender = false;
            this.bipedRightLeg.forceRender = false;
            this.bipedLeftLeg.forceRender = false;
            this.bipedRightArm.func_78793_a(-5.0f, 2.0f, 0.0f);
            this.bipedLeftArm.func_78793_a(5.0f, 2.0f, 0.0f);
            this.bipedRightLeg.func_78793_a(-2.0f, 12.0f, 0.0f);
            this.bipedLeftLeg.func_78793_a(2.0f, 12.0f, 0.0f);
            return false;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)entity;
        this.bipedOuter.field_78796_g = this.rotationYaw / 57.295776f;
        this.bipedOuter.fadeRotateAngleY = !player.func_184218_aH();
        boolean isStandardAnimation = false;
        float partialTicks = ageInTicks - (float)player.field_70173_aa;
        float horizontalSpeed = currentHorizontalSpeed;
        SmartMovingAbstractClientPlayer smPlayer = (SmartMovingAbstractClientPlayer)player;
        SmartMovingPlayerState state = smPlayer.getState();
        if (state.isCrawling) {
            float distance = totalHorizontalDistance * 1.3f;
            float walkFactor = SmartMovingModelBipedHandler.factor(horizontalSpeed, 0.0f, 0.12951545f);
            float standFactor = SmartMovingModelBipedHandler.factor(horizontalSpeed, 0.12951545f, 0.0f);
            this.bipedTorso.rotationOrder = ModelRotationRenderer.RotationOrder.YZX;
            this.bipedTorso.field_82907_q = -0.935f;
            this.bipedTorso.field_78795_f = 1.3744469f;
            this.bipedTorso.field_78797_d = 3.0f;
            this.bipedTorso.field_78808_h = MathHelper.func_76134_b((float)(distance + 1.5707964f)) * 0.09817477f * walkFactor;
            this.bipedBody.field_78796_g = MathHelper.func_76134_b((float)(distance + (float)Math.PI)) * 0.09817477f * walkFactor;
            this.bipedHead.field_78808_h = -headYawAngle / 57.295776f;
            this.bipedHead.field_78798_e = -1.5f;
            this.bipedHead.field_78795_f = -0.7853982f;
            float legRotateXOne = (MathHelper.func_76134_b((float)(distance - 1.5707964f)) * 0.09817477f + 0.19634955f) * walkFactor + 0.19634955f * standFactor;
            float legRotateXTwo = (MathHelper.func_76134_b((float)(distance - (float)Math.PI - 1.5707964f)) * 0.09817477f + 0.19634955f) * walkFactor + 0.19634955f * standFactor;
            if (player.field_191988_bg >= 0.0f) {
                this.bipedRightLeg.field_78795_f = legRotateXOne;
                this.bipedLeftLeg.field_78795_f = legRotateXTwo;
            } else {
                this.bipedRightLeg.field_78795_f = legRotateXTwo;
                this.bipedLeftLeg.field_78795_f = legRotateXOne;
            }
            this.bipedRightLeg.field_78808_h = (MathHelper.func_76134_b((float)(distance - 1.5707964f)) + 1.0f) * 0.25f * walkFactor + 0.19634955f * standFactor;
            this.bipedLeftLeg.field_78808_h = (MathHelper.func_76134_b((float)(distance - 1.5707964f)) - 1.0f) * 0.25f * walkFactor - 0.19634955f * standFactor;
            if (this.scaleLeg != ScaleType.NoScaleStart) {
                this.setLegScales(0.95f + (MathHelper.func_76134_b((float)(distance + 1.5707964f - 1.5707964f)) - 1.0f) * 0.25f * walkFactor, 0.95f + (MathHelper.func_76134_b((float)(distance - 1.5707964f - 1.5707964f)) - 1.0f) * 0.25f * walkFactor);
            }
            this.bipedRightArm.rotationOrder = ModelRotationRenderer.RotationOrder.YZX;
            this.bipedLeftArm.rotationOrder = ModelRotationRenderer.RotationOrder.YZX;
            this.bipedRightArm.field_78795_f = 3.7306414f;
            this.bipedLeftArm.field_78795_f = 3.7306414f;
            this.bipedRightArm.field_78808_h = (MathHelper.func_76134_b((float)(distance + (float)Math.PI)) * 0.09817477f + 0.19634955f) * walkFactor + 0.3926991f * standFactor;
            this.bipedLeftArm.field_78808_h = (MathHelper.func_76134_b((float)(distance + (float)Math.PI)) * 0.09817477f - 0.19634955f) * walkFactor - 0.3926991f * standFactor;
            this.bipedRightArm.field_78796_g = -1.5707964f;
            this.bipedLeftArm.field_78796_g = 1.5707964f;
            if (this.scaleArm != ScaleType.NoScaleStart) {
                this.setArmScales(0.95f + (MathHelper.func_76134_b((float)(distance + 1.5707964f)) - 1.0f) * 0.15f * walkFactor, 0.95f + (MathHelper.func_76134_b((float)(distance - 1.5707964f)) - 1.0f) * 0.15f * walkFactor);
            }
        } else if (player.func_184613_cA()) {
            this.animateElytraFlying((EntityLivingBase)entity, partialTicks, ageInTicks);
        } else {
            isStandardAnimation = true;
        }
        this.animateHeadRotation(isStandardAnimation, headYawAngle, headPitchAngle, player.func_184613_cA());
        if (player.func_70608_bn()) {
            this.animateSleeping(isStandardAnimation);
        }
        float f = elytraMagnitude = player.func_184599_cB() > 4 ? SmartMovingModelBipedHandler.getElytraMagnitude(entity) : 1.0f;
        if (isStandardAnimation || elytraMagnitude != 1.0f) {
            this.animateArmSwinging(totalHorizontalDistance, currentHorizontalSpeed, elytraMagnitude);
        }
        if (this.model.field_78093_q) {
            this.animateRiding(isStandardAnimation);
        }
        if (this.model.field_187075_l == ModelBiped.ArmPose.ITEM) {
            this.animateLeftArmItemHolding(isStandardAnimation);
        }
        if (this.model.field_187076_m == ModelBiped.ArmPose.ITEM) {
            this.animateRightArmItemHolding(isStandardAnimation);
        }
        if (this.model.field_78095_p > 0.0f) {
            this.animateSwinging(entity);
        }
        if (this.model.field_78117_n) {
            this.animateSneaking(isStandardAnimation);
        }
        this.animateArms(isStandardAnimation, ageInTicks);
        if (this.model.field_187076_m == ModelBiped.ArmPose.BOW_AND_ARROW) {
            this.animateBowAimingRight(ageInTicks);
        } else if (this.model.field_187075_l == ModelBiped.ArmPose.BOW_AND_ARROW) {
            this.animateBowAimingLeft(ageInTicks);
        }
        if (!this.bipedOuter.fadeRotateAngleX) {
            this.bipedOuter.previous.rotateAngleX = this.bipedOuter.field_78795_f;
        }
        if (!this.bipedOuter.fadeRotateAngleY) {
            this.bipedOuter.previous.rotateAngleY = this.bipedOuter.field_78796_g;
        }
        this.bipedOuter.fadeIntermediate(ageInTicks);
        this.bipedOuter.fadeStore(ageInTicks);
        return true;
    }

    private static float getElytraMagnitude(Entity entity) {
        float f = (float)(entity.field_70159_w * entity.field_70159_w + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y);
        f /= 0.2f;
        if ((f = f * f * f) < 1.0f) {
            return 1.0f;
        }
        return f;
    }

    public void postSetRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
    }

    public void reset() {
        this.bipedOuter.reset();
        this.bipedTorso.reset();
        this.bipedBody.reset();
        this.bipedBreast.reset();
        this.bipedNeck.reset();
        this.bipedHead.reset();
        this.bipedRightShoulder.reset();
        this.bipedRightArm.reset();
        this.bipedLeftShoulder.reset();
        this.bipedLeftArm.reset();
        this.bipedPelvic.reset();
        this.bipedRightLeg.reset();
        this.bipedLeftLeg.reset();
        this.bipedHeadwear.reset();
        this.bipedRightShoulder.func_78793_a(-5.0f, 2.0f, 0.0f);
        this.bipedLeftShoulder.func_78793_a(5.0f, 2.0f, 0.0f);
        this.bipedPelvic.func_78793_a(0.0f, 12.0f, 0.1f);
        this.bipedRightLeg.func_78793_a(-1.9f, 0.0f, 0.0f);
        this.bipedLeftLeg.func_78793_a(1.9f, 0.0f, 0.0f);
    }

    private void popMatrix() {
        if (this.doGLMatrixPop) {
            GL11.glPopMatrix();
        }
    }

    private void animateHeadRotation(boolean isStandardAnimation, float headYawAngle, float headPitchAngle, boolean elytraFlying) {
        if (!isStandardAnimation) {
            return;
        }
        this.bipedNeck.ignoreBase = !elytraFlying;
        this.bipedHead.field_78796_g = (elytraFlying ? 0.0f : this.rotationYaw + headYawAngle) / 57.295776f;
        this.bipedHead.field_78795_f = elytraFlying ? -0.7853982f : headPitchAngle / 57.295776f;
    }

    private void animateSleeping(boolean isStandardAnimation) {
        if (!isStandardAnimation) {
            return;
        }
        this.bipedNeck.ignoreBase = false;
        this.bipedHead.field_78796_g = 0.0f;
        this.bipedHead.field_78795_f = 0.7853982f;
        this.bipedTorso.field_78798_e = -17.0f;
    }

    private void animateArmSwinging(float totalHorizontalDistance, float currentHorizontalSpeed, float elytraMagnitude) {
        this.bipedRightArm.field_78795_f = MathHelper.func_76134_b((float)(totalHorizontalDistance * 0.6662f + (float)Math.PI)) * 2.0f * currentHorizontalSpeed * 0.5f / elytraMagnitude;
        this.bipedLeftArm.field_78795_f = MathHelper.func_76134_b((float)(totalHorizontalDistance * 0.6662f)) * 2.0f * currentHorizontalSpeed * 0.5f / elytraMagnitude;
        this.bipedRightLeg.field_78795_f = MathHelper.func_76134_b((float)(totalHorizontalDistance * 0.6662f)) * 1.4f * currentHorizontalSpeed / elytraMagnitude;
        this.bipedLeftLeg.field_78795_f = MathHelper.func_76134_b((float)(totalHorizontalDistance * 0.6662f + (float)Math.PI)) * 1.4f * currentHorizontalSpeed / elytraMagnitude;
    }

    private void animateRiding(boolean isStandardAnimation) {
        if (!isStandardAnimation) {
            return;
        }
        this.bipedRightArm.field_78795_f += -0.6283185f;
        this.bipedLeftArm.field_78795_f += -0.6283185f;
        this.bipedRightLeg.field_78795_f = -1.256637f;
        this.bipedLeftLeg.field_78795_f = -1.256637f;
        this.bipedRightLeg.field_78796_g = 0.3141593f;
        this.bipedLeftLeg.field_78796_g = -0.3141593f;
    }

    private void animateLeftArmItemHolding(boolean isStandardAnimation) {
        if (!isStandardAnimation) {
            return;
        }
        this.bipedLeftArm.field_78795_f = this.bipedLeftArm.field_78795_f * 0.5f - 0.3141593f;
    }

    private void animateRightArmItemHolding(boolean isStandardAnimation) {
        if (!isStandardAnimation) {
            return;
        }
        this.bipedRightArm.field_78795_f = this.bipedRightArm.field_78795_f * 0.5f - 0.3141593f;
    }

    private void animateSwinging(Entity entity) {
        float angle = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)this.model.field_78095_p) * ((float)Math.PI * 2))) * 0.2f;
        this.bipedBreast.field_78796_g = this.bipedBody.field_78796_g += angle;
        this.bipedBreast.rotationOrder = this.bipedBody.rotationOrder = ModelRotationRenderer.RotationOrder.YXZ;
        this.bipedLeftArm.field_78795_f += angle;
        EnumHandSide enumhandside = this.model.func_187072_a(entity);
        if (enumhandside == EnumHandSide.LEFT) {
            this.bipedBody.field_78796_g *= -1.0f;
        }
        float f1 = 1.0f - this.model.field_78095_p;
        f1 *= f1;
        f1 *= f1;
        f1 = 1.0f - f1;
        float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(this.model.field_78095_p * (float)Math.PI)) * -(this.bipedHead.field_78795_f - 0.7f) * 0.75f;
        ModelRenderer modelrenderer = this.getArmForSide(enumhandside);
        modelrenderer.field_78795_f = (float)((double)modelrenderer.field_78795_f - ((double)f2 * 1.2 + (double)f3));
        modelrenderer.field_78796_g += this.bipedBody.field_78796_g * 2.0f;
        modelrenderer.field_78808_h += MathHelper.func_76126_a((float)(this.model.field_78095_p * (float)Math.PI)) * -0.4f;
    }

    private void animateSneaking(boolean isStandardAnimation) {
        if (!isStandardAnimation) {
            return;
        }
        this.bipedTorso.field_78795_f += 0.5f;
        this.bipedRightLeg.field_78795_f += -0.5f;
        this.bipedLeftLeg.field_78795_f += -0.5f;
        this.bipedRightArm.field_78795_f += -0.1f;
        this.bipedLeftArm.field_78795_f += -0.1f;
        this.bipedPelvic.field_82908_p = -0.13652f;
        this.bipedPelvic.field_82907_q = -0.05652f;
        this.bipedBreast.field_82908_p = -0.01872f;
        this.bipedBreast.field_82907_q = -0.07502f;
        this.bipedNeck.field_82908_p = 0.0621f;
    }

    private void animateArms(boolean isStandardAnimation, float totalTime) {
        if (!isStandardAnimation) {
            return;
        }
        this.bipedRightArm.field_78808_h += MathHelper.func_76134_b((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedLeftArm.field_78808_h -= MathHelper.func_76134_b((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedRightArm.field_78795_f += MathHelper.func_76126_a((float)(totalTime * 0.067f)) * 0.05f;
        this.bipedLeftArm.field_78795_f -= MathHelper.func_76126_a((float)(totalTime * 0.067f)) * 0.05f;
    }

    private void animateBowAimingLeft(float totalTime) {
        this.bipedRightArm.field_78808_h = 0.0f;
        this.bipedLeftArm.field_78808_h = 0.0f;
        this.bipedRightArm.field_78796_g = -0.1f + this.bipedHead.field_78796_g - this.bipedOuter.field_78796_g - 0.4f;
        this.bipedLeftArm.field_78796_g = 0.1f + this.bipedHead.field_78796_g - this.bipedOuter.field_78796_g;
        this.bipedRightArm.field_78795_f = -1.570796f + this.bipedHead.field_78795_f;
        this.bipedLeftArm.field_78795_f = -1.570796f + this.bipedHead.field_78795_f;
        this.bipedRightArm.field_78808_h += MathHelper.func_76134_b((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedLeftArm.field_78808_h -= MathHelper.func_76134_b((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedRightArm.field_78795_f += MathHelper.func_76126_a((float)(totalTime * 0.067f)) * 0.05f;
        this.bipedLeftArm.field_78795_f -= MathHelper.func_76126_a((float)(totalTime * 0.067f)) * 0.05f;
    }

    private void animateBowAimingRight(float totalTime) {
        this.bipedRightArm.field_78808_h = 0.0f;
        this.bipedLeftArm.field_78808_h = 0.0f;
        this.bipedRightArm.field_78796_g = -0.1f + this.bipedHead.field_78796_g - this.bipedOuter.field_78796_g;
        this.bipedLeftArm.field_78796_g = 0.1f + this.bipedHead.field_78796_g - this.bipedOuter.field_78796_g + 0.4f;
        this.bipedRightArm.field_78795_f = -1.570796f + this.bipedHead.field_78795_f;
        this.bipedLeftArm.field_78795_f = -1.570796f + this.bipedHead.field_78795_f;
        this.bipedRightArm.field_78808_h += MathHelper.func_76134_b((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedLeftArm.field_78808_h -= MathHelper.func_76134_b((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedRightArm.field_78795_f += MathHelper.func_76126_a((float)(totalTime * 0.067f)) * 0.05f;
        this.bipedLeftArm.field_78795_f -= MathHelper.func_76126_a((float)(totalTime * 0.067f)) * 0.05f;
    }

    private void animateElytraFlying(EntityLivingBase entity, float partialTicks, float totalTime) {
        this.bipedTorso.rotationOrder = ModelRotationRenderer.RotationOrder.YZX;
        this.bipedTorso.field_78797_d = 23.5f;
        this.bipedTorso.field_82908_p = -1.15f;
        float f = (float)entity.func_184599_cB() + partialTicks;
        float f1 = MathHelper.func_76131_a((float)(f * f / 100.0f), (float)0.0f, (float)1.0f);
        this.bipedTorso.field_78795_f = f1 * (1.5707964f + entity.field_70125_A / 57.295776f);
        Vec3d vec3d = entity.func_70676_i(partialTicks);
        double d0 = entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y;
        double d1 = vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c;
        if (d0 > 0.0 && d1 > 0.0) {
            double d2 = (entity.field_70159_w * vec3d.field_72450_a + entity.field_70179_y * vec3d.field_72449_c) / (Math.sqrt(d0) * Math.sqrt(d1));
            double d3 = entity.field_70159_w * vec3d.field_72449_c - entity.field_70179_y * vec3d.field_72450_a;
            this.bipedTorso.field_78796_g = (float)(Math.signum(d3) * Math.acos(d2));
        }
        this.bipedRightArm.field_78808_h += MathHelper.func_76134_b((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedLeftArm.field_78808_h -= MathHelper.func_76134_b((float)(totalTime * 0.09f)) * 0.05f + 0.05f;
        this.bipedRightArm.field_78795_f += MathHelper.func_76126_a((float)(totalTime * 0.067f)) * 0.05f;
        this.bipedLeftArm.field_78795_f -= MathHelper.func_76126_a((float)(totalTime * 0.067f)) * 0.05f;
    }

    private void setArmScales(float rightScale, float leftScale) {
        if (this.scaleArm == ScaleType.Scale) {
            this.bipedRightArm.scaleY = rightScale;
            this.bipedLeftArm.scaleY = leftScale;
        } else if (this.scaleArm == ScaleType.NoScaleEnd) {
            this.bipedRightArm.field_82908_p -= (1.0f - rightScale) * 0.5f;
            this.bipedLeftArm.field_82908_p -= (1.0f - leftScale) * 0.5f;
        }
    }

    private void setLegScales(float rightScale, float leftScale) {
        if (this.scaleLeg == ScaleType.Scale) {
            this.bipedRightLeg.scaleY = rightScale;
            this.bipedLeftLeg.scaleY = leftScale;
        } else if (this.scaleLeg == ScaleType.NoScaleEnd) {
            this.bipedRightLeg.field_82908_p -= (1.0f - rightScale) * 0.5f;
            this.bipedLeftLeg.field_82908_p -= (1.0f - leftScale) * 0.5f;
        }
    }

    private static float factor(float a, float b, float c) {
        if (b > c) {
            if (a <= c) {
                return 1.0f;
            }
            if (a >= b) {
                return 0.0f;
            }
            return (b - a) / (b - c);
        }
        if (a >= c) {
            return 1.0f;
        }
        if (a <= b) {
            return 0.0f;
        }
        return (a - b) / (c - b);
    }

    private ModelRenderer getArmForSide(EnumHandSide side) {
        return side == EnumHandSide.LEFT ? this.bipedLeftArm : this.bipedRightArm;
    }

    public ModelRenderer getRandomModelBox(Random rand) {
        List boxList = this.model.field_78092_r;
        int size = boxList.size();
        int renderersWithBoxes = 0;
        int[] stack = new int[size + 1];
        for (int i = 0; i < size; ++i) {
            ModelRenderer renderer = (ModelRenderer)boxList.get(i);
            if (!SmartMovingModelBipedHandler.canBeRandomBoxSource(renderer)) continue;
            stack[renderersWithBoxes++] = i;
        }
        if (renderersWithBoxes != 0) {
            return (ModelRenderer)boxList.get(stack[rand.nextInt(renderersWithBoxes)]);
        }
        return null;
    }

    private static boolean canBeRandomBoxSource(ModelRenderer renderer) {
        return renderer.field_78804_l != null && renderer.field_78804_l.size() > 0 && (!(renderer instanceof ModelRotationRenderer) || ((ModelRotationRenderer)renderer).canBeRandomBoxSource());
    }

    public void setScaleArm(@NonNull ScaleType scaleArm) {
        if (scaleArm == null) {
            throw new NullPointerException("scaleArm is marked @NonNull but is null");
        }
        this.scaleArm = scaleArm;
    }

    public void setScaleLeg(@NonNull ScaleType scaleLeg) {
        if (scaleLeg == null) {
            throw new NullPointerException("scaleLeg is marked @NonNull but is null");
        }
        this.scaleLeg = scaleLeg;
    }
}

