/*
 * Decompiled with CFR 0.152.
 */
package com.tommsy.smartmoving.client.model;

import com.tommsy.smartmoving.client.model.SmartMovingModelBipedHandler;
import com.tommsy.smartmoving.client.model.SmartMovingModelPlayer;
import com.tommsy.smartmoving.client.renderer.ModelCapeRenderer;
import com.tommsy.smartmoving.client.renderer.ModelEarsRenderer;
import com.tommsy.smartmoving.client.renderer.ModelRotationRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.entity.Entity;
import org.lwjgl.opengl.GL11;

public class SmartMovingModelPlayerHandler
extends SmartMovingModelBipedHandler {
    private final SmartMovingModelPlayer smModel;
    private final ModelPlayer model;
    protected ModelEarsRenderer bipedEars;
    protected ModelCapeRenderer bipedCape;
    protected ModelRotationRenderer bipedBodywear;
    protected ModelRotationRenderer bipedRightArmwear;
    protected ModelRotationRenderer bipedLeftArmwear;
    protected ModelRotationRenderer bipedRightLegwear;
    protected ModelRotationRenderer bipedLeftLegwear;
    private final float smallArmsRotationPointY;

    public SmartMovingModelPlayerHandler(SmartMovingModelPlayer smModel) {
        super(smModel, false);
        this.smModel = smModel;
        this.model = this.smModel.getImplementation();
        this.smallArmsRotationPointY = this.model.field_178735_y ? 2.5f : 2.0f;
    }

    @Override
    protected void initializeRenderers() {
        super.initializeRenderers();
        this.bipedBodywear = new ModelRotationRenderer((ModelBase)this.model, this.bipedBody, this.model.field_178730_v);
        this.bipedRightArmwear = new ModelRotationRenderer((ModelBase)this.model, this.bipedRightArm, this.model.field_178732_b);
        this.bipedLeftArmwear = new ModelRotationRenderer((ModelBase)this.model, this.bipedLeftArm, this.model.field_178734_a);
        this.bipedRightLegwear = new ModelRotationRenderer((ModelBase)this.model, this.bipedRightLeg, this.model.field_178731_d);
        this.bipedLeftLegwear = new ModelRotationRenderer((ModelBase)this.model, this.bipedLeftLeg, this.model.field_178733_c);
        this.bipedCape = new ModelCapeRenderer((ModelBase)this.model, 0, 0, this.bipedBreast, this.bipedOuter);
        this.bipedCape.copyFrom(this.model.field_178729_w);
        this.bipedEars = new ModelEarsRenderer((ModelBase)this.model, 24, 0, this.bipedHead);
        this.bipedEars.copyFrom(this.model.field_178736_x);
        this.model.field_178730_v = this.bipedBodywear;
        this.model.field_178732_b = this.bipedRightArmwear;
        this.model.field_178734_a = this.bipedLeftArmwear;
        this.model.field_178731_d = this.bipedRightLegwear;
        this.model.field_178733_c = this.bipedLeftLegwear;
        this.model.field_178729_w = this.bipedCape;
        this.bipedCape.ignoreBase = false;
        this.bipedCape.field_78795_f = 0.09817477f;
        this.model.field_178736_x = this.bipedEars;
    }

    @Override
    public void preRender(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        super.preRender(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.bipedLeftLegwear.ignoreRender = true;
        this.bipedRightLegwear.ignoreRender = true;
        this.bipedLeftArmwear.ignoreRender = true;
        this.bipedRightArmwear.ignoreRender = true;
        this.bipedBodywear.ignoreRender = true;
    }

    @Override
    public void postRender(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        super.postRender(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.bipedLeftLegwear.ignoreRender = false;
        this.bipedRightLegwear.ignoreRender = false;
        this.bipedLeftArmwear.ignoreRender = false;
        this.bipedRightArmwear.ignoreRender = false;
        this.bipedBodywear.ignoreRender = false;
        this.bipedBodywear.renderIgnoreBase(scale);
        this.bipedRightArmwear.renderIgnoreBase(scale);
        this.bipedLeftArmwear.renderIgnoreBase(scale);
        this.bipedRightLegwear.renderIgnoreBase(scale);
        this.bipedLeftLegwear.renderIgnoreBase(scale);
        GL11.glPopMatrix();
    }

    @Override
    public boolean preSetRotationAngles(float totalHorizontalDistance, float currentHorizontalSpeed, float ageInTicks, float headYawAngle, float headPitchAngle, float scaleFactor, Entity entity) {
        boolean cancel = super.preSetRotationAngles(totalHorizontalDistance, currentHorizontalSpeed, ageInTicks, headYawAngle, headPitchAngle, scaleFactor, entity);
        if (!cancel) {
            this.bipedBodywear.ignoreBase = true;
            this.bipedHeadwear.ignoreBase = true;
            this.bipedRightArmwear.ignoreBase = true;
            this.bipedLeftArmwear.ignoreBase = true;
            this.bipedRightLegwear.ignoreBase = true;
            this.bipedLeftLegwear.ignoreBase = true;
            this.bipedEars.ignoreBase = true;
            this.bipedCape.ignoreBase = true;
            this.bipedBodywear.forceRender = false;
            this.bipedHeadwear.forceRender = false;
            this.bipedRightArmwear.forceRender = false;
            this.bipedLeftArmwear.forceRender = false;
            this.bipedRightLegwear.forceRender = false;
            this.bipedLeftLegwear.forceRender = false;
            this.bipedEars.forceRender = false;
            this.bipedCape.forceRender = false;
            return false;
        }
        return true;
    }

    @Override
    public void postSetRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        super.postSetRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
    }

    @Override
    public void reset() {
        this.bipedOuter.reset();
        this.bipedTorso.reset();
        this.bipedBody.reset();
        this.bipedBreast.reset();
        this.bipedNeck.reset();
        this.bipedHead.reset();
        this.bipedRightShoulder.reset();
        this.bipedRightArm.reset();
        this.bipedLeftShoulder.reset();
        this.bipedLeftArm.reset();
        this.bipedPelvic.reset();
        this.bipedRightLeg.reset();
        this.bipedLeftLeg.reset();
        this.bipedBodywear.reset();
        this.bipedRightArmwear.reset();
        this.bipedLeftArmwear.reset();
        this.bipedRightLegwear.reset();
        this.bipedLeftLegwear.reset();
        this.bipedEars.reset();
        this.bipedCape.reset();
        this.bipedRightShoulder.func_78793_a(-5.0f, this.smallArmsRotationPointY, 0.0f);
        this.bipedLeftShoulder.func_78793_a(5.0f, this.smallArmsRotationPointY, 0.0f);
        this.bipedPelvic.func_78793_a(0.0f, 12.0f, 0.1f);
        this.bipedRightLeg.func_78793_a(-1.9f, 0.0f, 0.0f);
        this.bipedLeftLeg.func_78793_a(1.9f, 0.0f, 0.0f);
        this.bipedCape.func_78793_a(0.0f, 0.0f, 2.0f);
    }
}

