/*
 * Decompiled with CFR 0.152.
 */
package com.tommsy.smartmoving.client.renderer;

import com.tommsy.smartmoving.client.renderer.ModelRotationRenderer;
import net.minecraft.client.model.ModelBase;

public class ModelPreviousRotationRenderer
extends ModelRotationRenderer {
    public final PreviousRendererData previous = new PreviousRendererData();
    public boolean fadeEnabled;
    public boolean fadeOffsetX;
    public boolean fadeOffsetY;
    public boolean fadeOffsetZ;
    public boolean fadeRotateAngleX;
    public boolean fadeRotateAngleY;
    public boolean fadeRotateAngleZ;
    public boolean fadeRotationPointX;
    public boolean fadeRotationPointY;
    public boolean fadeRotationPointZ;

    public ModelPreviousRotationRenderer(ModelBase modelBase, int texOffX, int texOffY, ModelRotationRenderer baseRenderer) {
        super(modelBase, texOffX, texOffY, baseRenderer);
    }

    public void fadeStore(float totalTime) {
        if (this.previous != null) {
            this.previous.offsetX = this.field_82906_o;
            this.previous.offsetY = this.field_82908_p;
            this.previous.offsetZ = this.field_82907_q;
            this.previous.rotateAngleX = this.field_78795_f;
            this.previous.rotateAngleY = this.field_78796_g;
            this.previous.rotateAngleZ = this.field_78808_h;
            this.previous.rotationPointX = this.field_78800_c;
            this.previous.rotationPointY = this.field_78797_d;
            this.previous.rotationPointZ = this.field_78798_e;
            this.previous.totalTime = totalTime;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.fadeOffsetZ = false;
        this.fadeOffsetY = false;
        this.fadeOffsetX = false;
        this.fadeRotateAngleZ = false;
        this.fadeRotateAngleY = false;
        this.fadeRotateAngleX = false;
        this.fadeRotationPointZ = false;
        this.fadeRotationPointY = false;
        this.fadeRotationPointX = false;
        this.previous.offsetZ = 0.0f;
        this.previous.offsetY = 0.0f;
        this.previous.offsetX = 0.0f;
        this.previous.rotateAngleZ = 0.0f;
        this.previous.rotateAngleY = 0.0f;
        this.previous.rotateAngleX = 0.0f;
        this.previous.totalTime = Float.MIN_VALUE;
    }

    public void fadeIntermediate(float totalTime) {
        if (this.previous != null && totalTime - this.previous.totalTime <= 2.0f) {
            this.field_82906_o = ModelPreviousRotationRenderer.getIntermediatePosition(this.previous.offsetX, this.field_82906_o, this.fadeOffsetX, this.previous.totalTime, totalTime);
            this.field_82908_p = ModelPreviousRotationRenderer.getIntermediatePosition(this.previous.offsetY, this.field_82908_p, this.fadeOffsetY, this.previous.totalTime, totalTime);
            this.field_82907_q = ModelPreviousRotationRenderer.getIntermediatePosition(this.previous.offsetZ, this.field_82907_q, this.fadeOffsetZ, this.previous.totalTime, totalTime);
            this.field_78795_f = ModelPreviousRotationRenderer.getIntermediateAngle(this.previous.rotateAngleX, this.field_78795_f, this.fadeRotateAngleX, this.previous.totalTime, totalTime);
            this.field_78796_g = ModelPreviousRotationRenderer.getIntermediateAngle(this.previous.rotateAngleY, this.field_78796_g, this.fadeRotateAngleY, this.previous.totalTime, totalTime);
            this.field_78808_h = ModelPreviousRotationRenderer.getIntermediateAngle(this.previous.rotateAngleZ, this.field_78808_h, this.fadeRotateAngleZ, this.previous.totalTime, totalTime);
            this.field_78800_c = ModelPreviousRotationRenderer.getIntermediatePosition(this.previous.rotationPointX, this.field_78800_c, this.fadeRotationPointX, this.previous.totalTime, totalTime);
            this.field_78797_d = ModelPreviousRotationRenderer.getIntermediatePosition(this.previous.rotationPointY, this.field_78797_d, this.fadeRotationPointY, this.previous.totalTime, totalTime);
            this.field_78798_e = ModelPreviousRotationRenderer.getIntermediatePosition(this.previous.rotationPointZ, this.field_78798_e, this.fadeRotationPointZ, this.previous.totalTime, totalTime);
        }
    }

    private static float getIntermediatePosition(float prevPosition, float shouldPosition, boolean fade, float lastTotalTime, float totalTime) {
        if (!fade || shouldPosition == prevPosition) {
            return shouldPosition;
        }
        return prevPosition + (shouldPosition - prevPosition) * (totalTime - lastTotalTime) * 0.2f;
    }

    private static float getIntermediateAngle(float prevAngle, float shouldAngle, boolean fade, float lastTotalTime, float totalTime) {
        if (!fade || shouldAngle == prevAngle) {
            return shouldAngle;
        }
        while (prevAngle >= (float)Math.PI * 2) {
            prevAngle -= (float)Math.PI * 2;
        }
        while (prevAngle < 0.0f) {
            prevAngle += (float)Math.PI * 2;
        }
        while (shouldAngle >= (float)Math.PI * 2) {
            shouldAngle -= (float)Math.PI * 2;
        }
        while (shouldAngle < 0.0f) {
            shouldAngle += (float)Math.PI * 2;
        }
        if (shouldAngle > prevAngle && shouldAngle - prevAngle > (float)Math.PI) {
            prevAngle += (float)Math.PI * 2;
        }
        if (shouldAngle < prevAngle && prevAngle - shouldAngle > (float)Math.PI) {
            shouldAngle += (float)Math.PI * 2;
        }
        return prevAngle + (shouldAngle - prevAngle) * (totalTime - lastTotalTime) * 0.2f;
    }

    public static class PreviousRendererData {
        public float offsetX;
        public float offsetY;
        public float offsetZ;
        public float rotateAngleX;
        public float rotateAngleY;
        public float rotateAngleZ;
        public float rotationPointX;
        public float rotationPointY;
        public float rotationPointZ;
        public float totalTime = Float.MIN_VALUE;
    }
}

