/*
 * Decompiled with CFR 0.152.
 */
package com.tommsy.smartmoving.client.renderer;

import java.nio.FloatBuffer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ModelRotationRenderer
extends ModelRenderer {
    protected ModelRotationRenderer base;
    public boolean ignoreRender;
    public boolean forceRender;
    public RotationOrder rotationOrder = RotationOrder.XYZ;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    public boolean ignoreBase;
    public boolean ignoreSuperRotation;
    private static FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
    private static float[] array = new float[16];

    public ModelRotationRenderer(ModelBase modelBase, ModelRotationRenderer base) {
        this(modelBase, -1, -1, base);
    }

    public ModelRotationRenderer(ModelBase modelBase, ModelRotationRenderer base, ModelRenderer original) {
        this(modelBase, original.field_78803_o, original.field_78813_p, base);
        this.copyFrom(original);
    }

    public ModelRotationRenderer(ModelBase modelBase, int texOffX, int texOffY, ModelRotationRenderer baseRenderer) {
        super(modelBase, texOffX, texOffY);
        this.field_78812_q = false;
        this.base = baseRenderer;
        if (this.base != null) {
            this.base.func_78792_a(this);
        }
        this.scaleZ = 1.0f;
        this.scaleY = 1.0f;
        this.scaleX = 1.0f;
    }

    public void copyFrom(ModelRenderer original) {
        if (original.field_78805_m != null) {
            for (Object childModel : original.field_78805_m) {
                this.func_78792_a((ModelRenderer)childModel);
            }
        }
        if (original.field_78804_l != null) {
            for (Object cube : original.field_78804_l) {
                this.field_78804_l.add((ModelBox)cube);
            }
        }
        this.field_78809_i = original.field_78809_i;
        this.field_78807_k = original.field_78807_k;
        this.field_78806_j = original.field_78806_j;
    }

    public void func_78785_a(float f) {
        if (!this.ignoreRender && !this.ignoreBase || this.forceRender) {
            this.doRender(f, this.ignoreBase);
        }
    }

    public void renderIgnoreBase(float f) {
        if (this.ignoreBase) {
            this.doRender(f, false);
        }
    }

    public void doRender(float f, boolean useParentTransformations) {
        if (!this.preRender(f)) {
            return;
        }
        this.preTransforms(f, true, useParentTransformations);
        GL11.glCallList((int)this.field_78811_r);
        if (this.field_78805_m != null) {
            for (int i = 0; i < this.field_78805_m.size(); ++i) {
                ((ModelRenderer)this.field_78805_m.get(i)).func_78785_a(f);
            }
        }
        this.postTransforms(f, true, useParentTransformations);
    }

    private boolean preRender(float f) {
        if (this.field_78807_k || !this.field_78806_j) {
            return false;
        }
        if (!this.field_78812_q) {
            this.func_78788_d(f);
        }
        return true;
    }

    public void preTransforms(float f, boolean push, boolean useParentTransformations) {
        if (this.base != null && !this.ignoreBase && useParentTransformations) {
            this.base.preTransforms(f, push, true);
        }
        this.preTransform(f, push);
    }

    public void preTransform(float f, boolean push) {
        if (this.field_78795_f != 0.0f || this.field_78796_g != 0.0f || this.field_78808_h != 0.0f || this.ignoreSuperRotation) {
            if (push) {
                GL11.glPushMatrix();
            }
            GL11.glTranslatef((float)(this.field_78800_c * f), (float)(this.field_78797_d * f), (float)(this.field_78798_e * f));
            if (this.ignoreSuperRotation) {
                buffer.rewind();
                GL11.glGetFloat((int)2982, (FloatBuffer)buffer);
                buffer.get(array);
                GL11.glLoadIdentity();
                GL11.glTranslatef((float)(array[12] / array[15]), (float)(array[13] / array[15]), (float)(array[14] / array[15]));
            }
            ModelRotationRenderer.rotate(this.rotationOrder, this.field_78795_f, this.field_78796_g, this.field_78808_h);
            GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            GL11.glTranslatef((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
        } else if (this.field_78800_c != 0.0f || this.field_78797_d != 0.0f || this.field_78798_e != 0.0f || this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f || this.field_82906_o != 0.0f || this.field_82908_p != 0.0f || this.field_82907_q != 0.0f) {
            GL11.glTranslatef((float)(this.field_78800_c * f), (float)(this.field_78797_d * f), (float)(this.field_78798_e * f));
            GL11.glScalef((float)this.scaleX, (float)this.scaleY, (float)this.scaleZ);
            GL11.glTranslatef((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
        }
    }

    private static void rotate(RotationOrder rotationOrder, float rotateAngleX, float rotateAngleY, float rotateAngleZ) {
        if (rotationOrder == RotationOrder.ZXY && rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (rotationOrder == RotationOrder.YXZ && rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)(rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if ((rotationOrder == RotationOrder.YZX || rotationOrder == RotationOrder.YXZ || rotationOrder == RotationOrder.ZXY || rotationOrder == RotationOrder.ZYX) && rotateAngleX != 0.0f) {
            GL11.glRotatef((float)(rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if ((rotationOrder == RotationOrder.XZY || rotationOrder == RotationOrder.ZYX) && rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if ((rotationOrder == RotationOrder.XYZ || rotationOrder == RotationOrder.XZY || rotationOrder == RotationOrder.YZX || rotationOrder == RotationOrder.ZXY || rotationOrder == RotationOrder.ZYX) && rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)(rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if ((rotationOrder == RotationOrder.XYZ || rotationOrder == RotationOrder.YXZ || rotationOrder == RotationOrder.YZX) && rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if ((rotationOrder == RotationOrder.XYZ || rotationOrder == RotationOrder.XZY) && rotateAngleX != 0.0f) {
            GL11.glRotatef((float)(rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    public void postTransform(float f, boolean pop) {
        if (this.field_78795_f != 0.0f || this.field_78796_g != 0.0f || this.field_78808_h != 0.0f || this.ignoreSuperRotation) {
            if (pop) {
                GL11.glPopMatrix();
            }
        } else if (this.field_78800_c != 0.0f || this.field_78797_d != 0.0f || this.field_78798_e != 0.0f || this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f || this.field_82906_o != 0.0f || this.field_82908_p != 0.0f || this.field_82907_q != 0.0f) {
            GL11.glTranslatef((float)(-this.field_82906_o), (float)(-this.field_82908_p), (float)(-this.field_82907_q));
            GL11.glScalef((float)(1.0f / this.scaleX), (float)(1.0f / this.scaleY), (float)(1.0f / this.scaleZ));
            GL11.glTranslatef((float)(-this.field_78800_c * f), (float)(-this.field_78797_d * f), (float)(-this.field_78798_e * f));
        }
    }

    public void postTransforms(float f, boolean pop, boolean useParentTransformations) {
        this.postTransform(f, pop);
        if (this.base != null && !this.ignoreBase && useParentTransformations) {
            this.base.postTransforms(f, pop, true);
        }
    }

    public void reset() {
        this.rotationOrder = RotationOrder.XYZ;
        this.scaleZ = 1.0f;
        this.scaleY = 1.0f;
        this.scaleX = 1.0f;
        this.field_78798_e = 0.0f;
        this.field_78797_d = 0.0f;
        this.field_78800_c = 0.0f;
        this.field_78808_h = 0.0f;
        this.field_78796_g = 0.0f;
        this.field_78795_f = 0.0f;
        this.ignoreBase = false;
        this.ignoreSuperRotation = false;
        this.forceRender = false;
        this.field_82907_q = 0.0f;
        this.field_82908_p = 0.0f;
        this.field_82906_o = 0.0f;
    }

    public void func_78794_c(float f) {
        if (!this.preRender(f)) {
            return;
        }
        this.preTransforms(f, false, true);
    }

    public boolean canBeRandomBoxSource() {
        return true;
    }

    public static enum RotationOrder {
        XYZ,
        XZY,
        YXZ,
        YZX,
        ZXY,
        ZYX;

    }
}

