/*
 * Decompiled with CFR 0.152.
 */
package com.tommsy.smartmoving.common;

import io.netty.buffer.ByteBuf;

public class SmartMovingPlayerState {
    public boolean isCrawling;
    public boolean isCrouching;

    public boolean isSneaking() {
        return this.isCrouching || this.isCrawling;
    }

    public void copy(SmartMovingPlayerState other) {
        this.isCrawling = other.isCrawling;
        this.isCrouching = other.isCrouching;
    }

    public void writeToBuffer(ByteBuf buf) {
        buf.writeBoolean(this.isCrawling);
        buf.writeBoolean(this.isCrouching);
    }

    public void readFromBuffer(ByteBuf buf) {
        this.isCrawling = buf.readBoolean();
        this.isCrouching = buf.readBoolean();
    }

    public String toString() {
        return "SmartMovingPlayerState(isCrawling=" + this.isCrawling + ", isCrouching=" + this.isCrouching + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmartMovingPlayerState)) {
            return false;
        }
        SmartMovingPlayerState other = (SmartMovingPlayerState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCrawling != other.isCrawling) {
            return false;
        }
        return this.isCrouching == other.isCrouching;
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmartMovingPlayerState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCrawling ? 79 : 97);
        result = result * 59 + (this.isCrouching ? 79 : 97);
        return result;
    }
}

