/*
 * Decompiled with CFR 0.152.
 */
package com.tommsy.smartmoving.config;

import com.tommsy.smartmoving.SmartMovingMod;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import net.minecraftforge.common.config.Config;

@Config(modid="smartmoving", name="SmartMoving", category="")
public final class SmartMovingConfigAccess {
    @Config.Name(value="general")
    public static final SmartMovingConfig LOCAL_CONFIG;
    @Config.Ignore
    public static SmartMovingConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(SmartMovingConfig config, OutputStream output) {
        ObjectOutputStream objectStream = null;
        try {
            objectStream = new ObjectOutputStream(output);
            objectStream.writeObject(config);
        }
        catch (IOException e) {
            SmartMovingMod.logger.error("Error writing to object stream", (Throwable)e);
        }
        finally {
            if (objectStream != null) {
                try {
                    objectStream.close();
                }
                catch (IOException e) {
                    SmartMovingMod.logger.error("Error closing object output stream", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmartMovingConfig deserialize(InputStream input) {
        ObjectInputStream objectStream = null;
        SmartMovingConfig config = LOCAL_CONFIG;
        try {
            objectStream = new ObjectInputStream(input);
            config = (SmartMovingConfig)objectStream.readObject();
        }
        catch (ClassNotFoundException e) {
            SmartMovingMod.logger.fatal("SmartMovingConfig class not found! Are the client and server versions the same?", (Throwable)e);
        }
        catch (IOException e) {
            SmartMovingMod.logger.error("Error reading object stream", (Throwable)e);
        }
        finally {
            if (objectStream != null) {
                try {
                    objectStream.close();
                }
                catch (IOException e) {
                    SmartMovingMod.logger.error("Error closing object input stream", (Throwable)e);
                }
            }
        }
        return config;
    }

    private SmartMovingConfigAccess() {
    }

    static {
        config = LOCAL_CONFIG = new SmartMovingConfig();
    }

    public static class SmartMovingConfig
    implements Serializable {
        @Config.Name(value="Movement")
        public Movement movement = new Movement();

        public String toString() {
            return "SmartMovingConfigAccess.SmartMovingConfig(movement=" + this.movement + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SmartMovingConfig)) {
                return false;
            }
            SmartMovingConfig other = (SmartMovingConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Movement this$movement = this.movement;
            Movement other$movement = other.movement;
            return !(this$movement == null ? other$movement != null : !((Object)this$movement).equals(other$movement));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SmartMovingConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Movement $movement = this.movement;
            result = result * 59 + ($movement == null ? 43 : ((Object)$movement).hashCode());
            return result;
        }

        public class Movement
        implements Serializable {
            @Config.Comment(value={"Fall distance for stopping ground based moves like crawling or sliding (>= 0)"})
            @Config.RangeDouble(min=0.0)
            public float fallingDistanceStart = 3.0f;

            public String toString() {
                return "SmartMovingConfigAccess.SmartMovingConfig.Movement(fallingDistanceStart=" + this.fallingDistanceStart + ")";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Movement)) {
                    return false;
                }
                Movement other = (Movement)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return Float.compare(this.fallingDistanceStart, other.fallingDistanceStart) == 0;
            }

            protected boolean canEqual(Object other) {
                return other instanceof Movement;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + Float.floatToIntBits(this.fallingDistanceStart);
                return result;
            }
        }
    }
}

