/*
 * Decompiled with CFR 0.152.
 */
package com.tommsy.smartmoving.mixin.client;

import com.tommsy.smartmoving.client.SmartMovingClientPlayer;
import com.tommsy.smartmoving.client.SmartMovingInput;
import com.tommsy.smartmoving.common.SmartMovingPlayerState;
import com.tommsy.smartmoving.config.SmartMovingConfigAccess;
import com.tommsy.smartmoving.mixin.client.MixinAbstractClientPlayer;
import com.tommsy.smartmoving.network.SmartMovingNetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.AxisAlignedBB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityPlayerSP.class})
public abstract class MixinEntityPlayerSP
extends MixinAbstractClientPlayer
implements SmartMovingClientPlayer {
    private SmartMovingInput playerInput;
    private SmartMovingPlayerState previousPlayerState;
    @Shadow
    protected Minecraft field_71159_c;
    @Shadow
    public MovementInput field_71158_b;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo ci) {
        this.playerInput = new SmartMovingInput(this.field_71159_c.field_71474_y);
        this.previousPlayerState = new SmartMovingPlayerState();
    }

    @Override
    public Minecraft getMinecraft() {
        return this.field_71159_c;
    }

    @Override
    protected void func_70664_aZ() {
        super.func_70664_aZ();
    }

    @Override
    @Overwrite
    public boolean func_70093_af() {
        return this.playerState.isSneaking();
    }

    @Override
    public void func_191986_a(float strafe, float vertical, float forward) {
        super.func_191986_a(strafe, vertical, forward);
    }

    @Inject(method={"onUpdate"}, at={@At(value="RETURN")})
    private void postUpdateRidden(CallbackInfo ci) {
    }

    @Inject(method={"onUpdate"}, at={@At(value="HEAD")})
    private void preOnUpdate(CallbackInfo ci) {
    }

    @Inject(method={"onUpdate"}, at={@At(value="RETURN")})
    private void postOnUpdate(CallbackInfo ci) {
    }

    @Inject(method={"onLivingUpdate"}, at={@At(value="HEAD")})
    private void preOnLivingUpdate(CallbackInfo ci) {
    }

    @Redirect(method={"onLivingUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/MovementInput;updatePlayerMoveState()V"))
    private void movementInputCorrection(MovementInput movementInput) {
        movementInput.func_78898_a();
        if (this.playerState.isCrouching) {
            movementInput.field_78902_a = (float)((double)movementInput.field_78902_a * 0.3);
            movementInput.field_192832_b = (float)((double)movementInput.field_192832_b * 0.3);
        } else if (this.playerState.isCrawling) {
            movementInput.field_78902_a = (float)((double)movementInput.field_78902_a * 0.15);
            movementInput.field_192832_b = (float)((double)movementInput.field_192832_b * 0.15);
        }
    }

    @Inject(method={"onLivingUpdate"}, at={@At(value="RETURN")})
    private void postOnLivingUpdate(CallbackInfo ci) {
    }

    @Inject(method={"updateEntityActionState"}, at={@At(value="RETURN")}, cancellable=true)
    private void postUpdateEntityActionState(CallbackInfo ci) {
        this.playerInput.update();
        if (this.func_184613_cA()) {
            this.playerState.isCrouching = false;
            this.playerState.isCrawling = false;
        }
        boolean mustCrawl = false;
        if (this.playerState.isCrawling) {
            mustCrawl = this.checkForCollision(0.6f, 1.8f);
        }
        if (!mustCrawl) {
            boolean canCrawl;
            boolean bl = canCrawl = this.field_70143_R < SmartMovingConfigAccess.config.movement.fallingDistanceStart;
            this.playerState.isCrawling = canCrawl ? (this.playerState.isCrawling ? this.playerInput.sneak.pressed : this.playerInput.grab.startPressed && this.playerInput.sneak.pressed && this.field_70122_E && !this.field_71075_bZ.field_75100_b) : false;
        }
        this.playerState.isCrouching = !this.playerState.isCrawling && this.playerInput.sneak.pressed;
        this.sendPlayerState();
    }

    @Unique
    private boolean checkForCollision(float width, float height) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        axisalignedbb = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)width, axisalignedbb.field_72338_b + (double)height, axisalignedbb.field_72339_c + (double)width);
        return this.field_70170_p.func_184143_b(axisalignedbb);
    }

    @Unique
    private void sendPlayerState() {
        if (!this.playerState.equals(this.previousPlayerState)) {
            SmartMovingNetworkHandler.sendClientPlayerStateChange(this.playerState);
        }
        this.previousPlayerState.copy(this.playerState);
    }
}

