/*
 * Decompiled with CFR 0.152.
 */
package com.tommsy.smartmoving.mixin.client;

import com.tommsy.smartmoving.client.model.SmartMovingModelPlayer;
import com.tommsy.smartmoving.client.model.SmartMovingModelPlayerHandler;
import java.util.Random;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelPlayer.class})
public abstract class MixinModelPlayer
extends ModelBiped
implements SmartMovingModelPlayer {
    private SmartMovingModelPlayerHandler handler;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstructed(float modelSize, boolean useSmallArms, CallbackInfo ci) {
        this.handler = new SmartMovingModelPlayerHandler(this);
        this.handler.initialize();
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void preRender(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale, CallbackInfo ci) {
        this.handler.preRender(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void postRender(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale, CallbackInfo ci) {
        this.handler.postRender(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    @Inject(method={"setRotationAngles"}, at={@At(value="HEAD")}, cancellable=true)
    private void preSetRotationAngles(float totalHorizontalDistance, float currentHorizontalSpeed, float ageInTicks, float headYawAngle, float headPitchAngle, float scaleFactor, Entity entity, CallbackInfo ci) {
        boolean cancel = this.handler.preSetRotationAngles(totalHorizontalDistance, currentHorizontalSpeed, ageInTicks, headYawAngle, headPitchAngle, scaleFactor, entity);
        if (cancel) {
            ci.cancel();
        }
    }

    @Inject(method={"setRotationAngles"}, at={@At(value="RETURN")})
    private void postSetRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn, CallbackInfo ci) {
        this.handler.postSetRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
    }

    public ModelRenderer func_85181_a(Random rand) {
        return this.handler.getRandomModelBox(rand);
    }

    @Override
    public SmartMovingModelPlayerHandler getHandler() {
        return this.handler;
    }
}

