/*
 * Decompiled with CFR 0.152.
 */
package com.tommsy.smartmoving.network;

import com.tommsy.smartmoving.common.SmartMovingPlayerState;
import com.tommsy.smartmoving.network.SmartMovingNetworkHandler;
import com.tommsy.smartmoving.server.SmartMovingServerPlayer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientPlayerStateChangeMessage
implements IMessage {
    private SmartMovingPlayerState state;
    private ByteBuf stateBytes;

    public ClientPlayerStateChangeMessage(SmartMovingPlayerState state) {
        this.state = state;
    }

    public void toBytes(ByteBuf buf) {
        this.state.writeToBuffer(buf);
    }

    public void fromBytes(ByteBuf buf) {
        this.stateBytes = buf.asReadOnly();
        this.stateBytes.retain();
    }

    private void writeToPlayerState(SmartMovingPlayerState state) {
        state.readFromBuffer(this.stateBytes);
        this.stateBytes.release();
    }

    public ClientPlayerStateChangeMessage() {
    }

    public static class ClientPlayerStateChangeHandler
    implements IMessageHandler<ClientPlayerStateChangeMessage, IMessage> {
        public IMessage onMessage(ClientPlayerStateChangeMessage message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            message.stateBytes.retain();
            SmartMovingNetworkHandler.sendServerPlayerStateChange(message.stateBytes.duplicate(), (Entity)player);
            player.func_71121_q().func_152344_a(() -> message.writeToPlayerState(((SmartMovingServerPlayer)player).getState()));
            return null;
        }
    }
}

