/*
 * Decompiled with CFR 0.152.
 */
package com.tommsy.smartmoving.network;

import com.tommsy.smartmoving.SmartMovingMod;
import com.tommsy.smartmoving.config.SmartMovingConfigAccess;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ConfigUpdateMessage
implements IMessage {
    private static volatile byte[] cacheBytes;
    private static volatile SmartMovingConfigAccess.SmartMovingConfig cacheConfig;
    private SmartMovingConfigAccess.SmartMovingConfig config;

    public ConfigUpdateMessage(SmartMovingConfigAccess.SmartMovingConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toBytes(ByteBuf buf) {
        ConfigUpdateMessage configUpdateMessage = this;
        synchronized (configUpdateMessage) {
            if (!this.config.equals(cacheConfig)) {
                AccessibleByteArrayOutputStream bytes = new AccessibleByteArrayOutputStream();
                SmartMovingConfigAccess.serialize(this.config, bytes);
                cacheBytes = bytes.getBuffer();
                cacheConfig = SmartMovingConfigAccess.deserialize(new ByteArrayInputStream(cacheBytes));
            }
        }
        buf.writeBytes(cacheBytes);
    }

    public void fromBytes(ByteBuf buf) {
        this.config = SmartMovingConfigAccess.deserialize((InputStream)new ByteBufInputStream(buf));
    }

    public ConfigUpdateMessage() {
    }

    public static class ConfigUpdateMessageHandler
    implements IMessageHandler<ConfigUpdateMessage, IMessage> {
        public IMessage onMessage(ConfigUpdateMessage message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                SmartMovingConfigAccess.config = message.config;
                SmartMovingMod.logger.debug("Received config from server.");
            });
            return null;
        }
    }

    private static class AccessibleByteArrayOutputStream
    extends ByteArrayOutputStream {
        private AccessibleByteArrayOutputStream() {
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

