/*
 * Decompiled with CFR 0.152.
 */
package com.tommsy.smartmoving.network;

import com.tommsy.smartmoving.SmartMovingMod;
import com.tommsy.smartmoving.client.SmartMovingOtherPlayer;
import com.tommsy.smartmoving.common.SmartMovingPlayerState;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ServerPlayerStateChangeMessage
implements IMessage {
    private ByteBuf stateBytes;
    private int entityId;

    public ServerPlayerStateChangeMessage(ByteBuf stateBytes, int entityId) {
        this.stateBytes = stateBytes;
        this.entityId = entityId;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBytes(this.stateBytes);
        this.stateBytes.release();
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.stateBytes = buf.asReadOnly();
        this.stateBytes.retain();
    }

    private void writeToPlayerState(SmartMovingPlayerState state) {
        state.readFromBuffer(this.stateBytes);
        this.stateBytes.release();
    }

    public ServerPlayerStateChangeMessage() {
    }

    public static class ServerPlayerStateChangeHandler
    implements IMessageHandler<ServerPlayerStateChangeMessage, IMessage> {
        public IMessage onMessage(ServerPlayerStateChangeMessage message, MessageContext ctx) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (entity == null) {
                SmartMovingMod.logger.warn("Null entity when handling {}", (Object)message.getClass().getSimpleName());
            } else if (!(entity instanceof SmartMovingOtherPlayer)) {
                SmartMovingMod.logger.warn("Entity not instance of {} when handling {}", (Object)SmartMovingOtherPlayer.class.getSimpleName(), (Object)message.getClass().getSimpleName());
            } else {
                Minecraft.func_71410_x().func_152344_a(() -> message.writeToPlayerState(((SmartMovingOtherPlayer)entity).getState()));
            }
            return null;
        }
    }
}

