/*
 * Decompiled with CFR 0.152.
 */
package com.tommsy.smartmoving.network;

import com.tommsy.smartmoving.common.SmartMovingPlayerState;
import com.tommsy.smartmoving.config.SmartMovingConfigAccess;
import com.tommsy.smartmoving.network.ClientPlayerStateChangeMessage;
import com.tommsy.smartmoving.network.ConfigUpdateMessage;
import com.tommsy.smartmoving.network.ServerPlayerStateChangeMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public final class SmartMovingNetworkHandler {
    private static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("SmrtMvng");

    public static void registerMessages() {
        INSTANCE.registerMessage(ServerPlayerStateChangeMessage.ServerPlayerStateChangeHandler.class, ServerPlayerStateChangeMessage.class, 0, Side.CLIENT);
        INSTANCE.registerMessage(ClientPlayerStateChangeMessage.ClientPlayerStateChangeHandler.class, ClientPlayerStateChangeMessage.class, 1, Side.SERVER);
        INSTANCE.registerMessage(ConfigUpdateMessage.ConfigUpdateMessageHandler.class, ConfigUpdateMessage.class, 2, Side.CLIENT);
    }

    public static void sendClientPlayerStateChange(SmartMovingPlayerState state) {
        INSTANCE.sendToServer((IMessage)new ClientPlayerStateChangeMessage(state));
    }

    public static void sendServerPlayerStateChange(ByteBuf stateBytes, Entity entity) {
        INSTANCE.sendToAllTracking((IMessage)new ServerPlayerStateChangeMessage(stateBytes, entity.func_145782_y()), entity);
    }

    public static void sendConfigUpdate(EntityPlayerMP player) {
        INSTANCE.sendTo((IMessage)new ConfigUpdateMessage(SmartMovingConfigAccess.LOCAL_CONFIG), player);
    }

    public static void sendConfigUpdateToAll() {
        INSTANCE.sendToAll((IMessage)new ConfigUpdateMessage(SmartMovingConfigAccess.LOCAL_CONFIG));
    }

    private SmartMovingNetworkHandler() {
    }
}

