/*
 * Decompiled with CFR 0.152.
 */
package genandnic.walljump.proxy;

import genandnic.walljump.WallJumpConfig;
import genandnic.walljump.enchantment.DoubleJumpEnchant;
import genandnic.walljump.enchantment.SpeedBoostEnchant;
import genandnic.walljump.enchantment.WallJumpEnchant;
import genandnic.walljump.packet.PacketFallDistance;
import genandnic.walljump.packet.PacketForceConfig;
import genandnic.walljump.packet.PacketWallJump;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class CommonProxy {
    public static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("walljump");
    public static final Enchantment WALLJUMP_ENCHANT = new WallJumpEnchant();
    public static final Enchantment DOUBLEJUMP_ENCHANT = new DoubleJumpEnchant();
    public static final Enchantment SPEEDBOOST_ENCHANT = new SpeedBoostEnchant();

    public void preInit(FMLPreInitializationEvent event) {
    }

    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        int id = 0;
        NETWORK.registerMessage(PacketForceConfig.PacketForceConfigHandler.class, PacketForceConfig.class, id++, Side.CLIENT);
        NETWORK.registerMessage(PacketWallJump.PacketWallJumpHandler.class, PacketWallJump.class, id++, Side.SERVER);
        NETWORK.registerMessage(PacketFallDistance.PacketFallDistanceHandler.class, PacketFallDistance.class, id++, Side.SERVER);
    }

    public void postInit(FMLPostInitializationEvent event) {
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        NETWORK.sendTo((IMessage)new PacketForceConfig(), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        float distance = event.getDistance();
        if (distance > 3.0f && (double)distance <= WallJumpConfig.minFallDistance) {
            event.setDistance(3.0f);
            event.getEntity().func_184185_a(SoundEvents.field_187545_bE, 0.5f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void registerEnchants(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Enchantment[]{WALLJUMP_ENCHANT, DOUBLEJUMP_ENCHANT, SPEEDBOOST_ENCHANT});
    }
}

