/*
* Smart Moving Reloaded
* Copyright (C) 2018  Tommsy64
*
* Smart Moving Reloaded is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Smart Moving Reloaded is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Smart Moving Reloaded.  If not, see <http://www.gnu.org/licenses/>.
*/

package com.tommsy.smartmoving.client.model;

import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import com.tommsy.smartmoving.client.SmartMovingAbstractClientPlayer;
import com.tommsy.smartmoving.client.renderer.ModelSpecialRenderer;
import com.tommsy.smartmoving.client.renderer.RenderUtils;
import com.tommsy.smartmoving.common.SmartMovingPlayerState;

@SideOnly(Side.CLIENT)
public class SmartMovingModelElytra extends ModelBase {

    private final ModelSpecialRenderer leftWing, rightWing;

    public SmartMovingModelElytra(SmartMovingModelPlayer smModel) {
        SmartMovingModelPlayerHandler handle = smModel.getHandler();

        this.leftWing = new ModelSpecialRenderer(this, 22, 0, handle.bipedBody);
        this.leftWing.func_78790_a(-10.0F, 0.0F, 0.0F, 10, 20, 2, 1.0F);

        this.rightWing = new ModelSpecialRenderer(this, 22, 0, handle.bipedBody);
        this.rightWing.field_78809_i = true;
        this.rightWing.func_78790_a(0.0F, 0.0F, 0.0F, 10, 20, 2, 1.0F);
    }

    public void func_78088_a(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        beforeRender();
        GlStateManager.func_179101_C();
        GlStateManager.func_179129_p();

        if (((EntityLivingBase) entity).func_70631_g_()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a(0.5F, 0.5F, 0.5F);
            GlStateManager.func_179109_b(0.0F, 1.5F, -0.1F);
            this.leftWing.func_78785_a(scale);
            this.rightWing.func_78785_a(scale);
            GlStateManager.func_179121_F();
        } else {
            this.leftWing.func_78785_a(scale);
            this.rightWing.func_78785_a(scale);
        }
        afterRender();
    }

    private void beforeRender() {
        this.leftWing.beforeRender(true);
        this.rightWing.beforeRender(true);
    }

    private void afterRender() {
        this.leftWing.afterRender();
        this.rightWing.afterRender();
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entity) {
        super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entity);
        float angleFromNeck = 0.2617994F;
        float wingSpread = -0.2617994F;
        float offsetFromNeck = 0.0F;
        float f3 = 0.0F;

        SmartMovingAbstractClientPlayer smPlayer = (SmartMovingAbstractClientPlayer) entity;
        SmartMovingPlayerState state = smPlayer.getState();

        if (((EntityLivingBase) entity).func_184613_cA()) {
            float f4 = 1.0F;

            if (entity.field_70181_x < 0.0D) {
                Vec3d vec3d = (new Vec3d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y)).func_72432_b();
                f4 = 1.0F - (float) Math.pow(-vec3d.field_72448_b, 1.5D);
            }

            angleFromNeck = f4 * 0.34906584F + (1.0F - f4) * angleFromNeck;
            wingSpread = f4 * -((float) Math.PI / 2F) + (1.0F - f4) * wingSpread;
        } else if (state.isCrouching) {
            angleFromNeck = RenderUtils.Whole / 9F;
            wingSpread = -RenderUtils.Eighth;
            offsetFromNeck = 3.0F;
            f3 = RenderUtils.Half / 36F;
        } else if (state.isCrawling) {
            angleFromNeck = RenderUtils.Sixtyfourth;
            wingSpread = -RenderUtils.Sixteenth;
            offsetFromNeck = 3.0F;
            f3 = RenderUtils.Half / 36F;
        }

        this.leftWing.field_78800_c = 5.0F;
        this.leftWing.field_78797_d = offsetFromNeck;

        AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer) entity;
        abstractclientplayer.field_184835_a = (float) ((double) abstractclientplayer.field_184835_a + (double) (angleFromNeck - abstractclientplayer.field_184835_a) * 0.1D);
        abstractclientplayer.field_184836_b = (float) ((double) abstractclientplayer.field_184836_b + (double) (f3 - abstractclientplayer.field_184836_b) * 0.1D);
        abstractclientplayer.field_184837_c = (float) ((double) abstractclientplayer.field_184837_c + (double) (wingSpread - abstractclientplayer.field_184837_c) * 0.1D);
        this.leftWing.field_78795_f = abstractclientplayer.field_184835_a;
        this.leftWing.field_78796_g = abstractclientplayer.field_184836_b;
        this.leftWing.field_78808_h = abstractclientplayer.field_184837_c;

        this.rightWing.field_78800_c = -this.leftWing.field_78800_c;
        this.rightWing.field_78796_g = -this.leftWing.field_78796_g;
        this.rightWing.field_78797_d = this.leftWing.field_78797_d;
        this.rightWing.field_78795_f = this.leftWing.field_78795_f;
        this.rightWing.field_78808_h = -this.leftWing.field_78808_h;
    }
}
