/*
* Smart Moving Reloaded
* Copyright (C) 2018  Tommsy64
*
* Smart Moving Reloaded is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Smart Moving Reloaded is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Smart Moving Reloaded.  If not, see <http://www.gnu.org/licenses/>.
*/

package com.tommsy.smartmoving.client.renderer;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;

import static com.tommsy.smartmoving.client.renderer.RenderUtils.RadianToAngle;

public class ModelCapeRenderer extends ModelSpecialRenderer {
    private final ModelRotationRenderer outer;
    private EntityPlayer entityplayer;
    private float setFactor;

    public ModelCapeRenderer(ModelBase modelBase, int texOffX, int texOffY, ModelRotationRenderer baseRenderer, ModelRotationRenderer outerRenderer) {
        super(modelBase, texOffX, texOffY, baseRenderer);
        outer = outerRenderer;
    }

    public void beforeRender(EntityPlayer entityplayer, float factor) {
        this.entityplayer = entityplayer;
        this.setFactor = factor;

        super.beforeRender(true);
    }

    @Override
    public void preTransform(float factor, boolean push) {
        if (entityplayer.func_70093_af())
            GL11.glTranslatef(0.0F, 0.2F, 0.0F);

        super.preTransform(factor, push);

        double d = (entityplayer.field_71091_bM + (entityplayer.field_71094_bP - entityplayer.field_71091_bM) * setFactor) - (entityplayer.field_70169_q + (entityplayer.field_70165_t
                - entityplayer.field_70169_q) * setFactor);
        double d1 = (entityplayer.field_71096_bN + (entityplayer.field_71095_bQ - entityplayer.field_71096_bN) * setFactor) - (entityplayer.field_70167_r + (entityplayer.field_70163_u
                - entityplayer.field_70167_r) * setFactor);
        double d2 = (entityplayer.field_71097_bO + (entityplayer.field_71085_bR - entityplayer.field_71097_bO) * setFactor) - (entityplayer.field_70166_s + (entityplayer.field_70161_v
                - entityplayer.field_70166_s) * setFactor);
        float f1 = entityplayer.field_70760_ar + (entityplayer.field_70761_aq - entityplayer.field_70760_ar) * setFactor;
        double d3 = MathHelper.func_76126_a((f1 * 3.141593F) / 180F);
        double d4 = -MathHelper.func_76134_b((f1 * 3.141593F) / 180F);
        float f2 = (float) d1 * 10F;
        if (f2 < -6F) {
            f2 = -6F;
        }
        if (f2 > 32F) {
            f2 = 32F;
        }
        float f3 = (float) (d * d3 + d2 * d4) * 100F;
        float f4 = (float) (d * d4 - d2 * d3) * 100F;
        if (f3 < 0.0F) {
            f3 = 0.0F;
        }
        float f5 = entityplayer.field_71107_bF + (entityplayer.field_71109_bG - entityplayer.field_71107_bF) * setFactor;
        f2 += MathHelper.func_76126_a((entityplayer.field_70141_P + (entityplayer.field_70140_Q - entityplayer.field_70141_P) * setFactor) * 6F) * 32F
                * f5;

        if (entityplayer.func_70093_af()) {
            GlStateManager.func_179109_b(0.0F, 0.009F, 0.044F);
            f2 -= 9.24F;
        } else
            f2 -= 5.62F;

        float localAngle = 6F + f3 / 2.0F + f2;
        float localAngleMax = Math.max(70.523F - outer.field_78795_f * RadianToAngle, 6F);
        float realLocalAngle = Math.min(localAngle, localAngleMax);

        GL11.glRotatef(realLocalAngle, 1.0F, 0.0F, 0.0F);
        GL11.glRotatef(f4 / 2.0F, 0.0F, 0.0F, 1.0F);
        GL11.glRotatef(-f4 / 2.0F, 0.0F, 1.0F, 0.0F);
        GL11.glRotatef(180F, 0.0F, 1.0F, 0.0F);
    }

    @Override
    public boolean canBeRandomBoxSource() {
        return false;
    }
}
