/*
* Smart Moving Reloaded
* Copyright (C) 2018  Tommsy64
*
* Smart Moving Reloaded is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Smart Moving Reloaded is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Smart Moving Reloaded.  If not, see <http://www.gnu.org/licenses/>.
*/

package com.tommsy.smartmoving.client.renderer;

import net.minecraft.client.model.ModelBase;

import static com.tommsy.smartmoving.client.renderer.RenderUtils.Half;
import static com.tommsy.smartmoving.client.renderer.RenderUtils.Whole;

public class ModelPreviousRotationRenderer extends ModelRotationRenderer {
    public final PreviousRendererData previous;

    public boolean fadeEnabled;

    public boolean fadeOffsetX, fadeOffsetY, fadeOffsetZ;
    public boolean fadeRotateAngleX, fadeRotateAngleY, fadeRotateAngleZ;
    public boolean fadeRotationPointX, fadeRotationPointY, fadeRotationPointZ;

    public static class PreviousRendererData {
        public float offsetX, offsetY, offsetZ;
        public float rotateAngleX, rotateAngleY, rotateAngleZ;
        public float rotationPointX, rotationPointY, rotationPointZ;
        public float totalTime = Float.MIN_VALUE;
    }

    public ModelPreviousRotationRenderer(ModelBase modelBase, int texOffX, int texOffY, ModelRotationRenderer baseRenderer) {
        super(modelBase, texOffX, texOffY, baseRenderer);
        previous = new PreviousRendererData();
    }

    public void fadeStore(float totalTime) {
        if (previous != null) {
            previous.offsetX = field_82906_o;
            previous.offsetY = field_82908_p;
            previous.offsetZ = field_82907_q;
            previous.rotateAngleX = field_78795_f;
            previous.rotateAngleY = field_78796_g;
            previous.rotateAngleZ = field_78808_h;
            previous.rotationPointX = field_78800_c;
            previous.rotationPointY = field_78797_d;
            previous.rotationPointZ = field_78798_e;
            previous.totalTime = totalTime;
        }
    }

    @Override
    public void reset() {
        super.reset();
        fadeOffsetX = fadeOffsetY = fadeOffsetZ = false;
        fadeRotateAngleX = fadeRotateAngleY = fadeRotateAngleZ = false;
        fadeRotationPointX = fadeRotationPointY = fadeRotationPointZ = false;
        previous.offsetX = previous.offsetY = previous.offsetZ = 0;
        previous.rotateAngleX = previous.rotateAngleY = previous.rotateAngleZ = 0;
        previous.totalTime = Float.MIN_VALUE;
    }

    public void fadeIntermediate(float totalTime) {
        if (previous != null && totalTime - previous.totalTime <= 2F) {
            field_82906_o = getIntermediatePosition(previous.offsetX, field_82906_o, fadeOffsetX, previous.totalTime, totalTime);
            field_82908_p = getIntermediatePosition(previous.offsetY, field_82908_p, fadeOffsetY, previous.totalTime, totalTime);
            field_82907_q = getIntermediatePosition(previous.offsetZ, field_82907_q, fadeOffsetZ, previous.totalTime, totalTime);

            field_78795_f = getIntermediateAngle(previous.rotateAngleX, field_78795_f, fadeRotateAngleX, previous.totalTime, totalTime);
            field_78796_g = getIntermediateAngle(previous.rotateAngleY, field_78796_g, fadeRotateAngleY, previous.totalTime, totalTime);
            field_78808_h = getIntermediateAngle(previous.rotateAngleZ, field_78808_h, fadeRotateAngleZ, previous.totalTime, totalTime);

            field_78800_c = getIntermediatePosition(previous.rotationPointX, field_78800_c, fadeRotationPointX, previous.totalTime, totalTime);
            field_78797_d = getIntermediatePosition(previous.rotationPointY, field_78797_d, fadeRotationPointY, previous.totalTime, totalTime);
            field_78798_e = getIntermediatePosition(previous.rotationPointZ, field_78798_e, fadeRotationPointZ, previous.totalTime, totalTime);
        }
    }

    private static float getIntermediatePosition(float prevPosition, float shouldPosition, boolean fade, float lastTotalTime, float totalTime) {
        if (!fade || shouldPosition == prevPosition)
            return shouldPosition;

        return prevPosition + (shouldPosition - prevPosition) * (totalTime - lastTotalTime) * 0.2F;
    }

    private static float getIntermediateAngle(float prevAngle, float shouldAngle, boolean fade, float lastTotalTime, float totalTime) {
        if (!fade || shouldAngle == prevAngle)
            return shouldAngle;

        while (prevAngle >= Whole)
            prevAngle -= Whole;
        while (prevAngle < 0F)
            prevAngle += Whole;

        while (shouldAngle >= Whole)
            shouldAngle -= Whole;
        while (shouldAngle < 0F)
            shouldAngle += Whole;

        if (shouldAngle > prevAngle && (shouldAngle - prevAngle) > Half)
            prevAngle += Whole;

        if (shouldAngle < prevAngle && (prevAngle - shouldAngle) > Half)
            shouldAngle += Whole;

        return prevAngle + (shouldAngle - prevAngle) * (totalTime - lastTotalTime) * 0.2F;
    }
}
