/*
* Smart Moving Reloaded
* Copyright (C) 2018  Tommsy64
*
* Smart Moving Reloaded is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Smart Moving Reloaded is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Smart Moving Reloaded.  If not, see <http://www.gnu.org/licenses/>.
*/

package com.tommsy.smartmoving.client.renderer;

import java.nio.FloatBuffer;

import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;

import static com.tommsy.smartmoving.client.renderer.RenderUtils.RadianToAngle;

public class ModelRotationRenderer extends ModelRenderer {

    protected ModelRotationRenderer base;

    public boolean ignoreRender;
    public boolean forceRender;

    public RotationOrder rotationOrder;

    public float scaleX, scaleY, scaleZ;

    public boolean ignoreBase;
    public boolean ignoreSuperRotation;

    public static enum RotationOrder {
        XYZ, XZY, YXZ, YZX, ZXY, ZYX
    }

    public ModelRotationRenderer(ModelBase modelBase, ModelRotationRenderer base) {
        this(modelBase, -1, -1, base);
    }

    public ModelRotationRenderer(ModelBase modelBase, ModelRotationRenderer base, ModelRenderer original) {
        this(modelBase, original.field_78803_o, original.field_78813_p, base);
        copyFrom(original);
    }

    public ModelRotationRenderer(ModelBase modelBase, int texOffX, int texOffY, ModelRotationRenderer baseRenderer) {
        super(modelBase, texOffX, texOffY);
        rotationOrder = RotationOrder.XYZ;
        field_78812_q = false;

        base = baseRenderer;
        if (base != null)
            base.func_78792_a(this);

        scaleX = scaleY = scaleZ = 1.0F;
    }

    public void copyFrom(ModelRenderer original) {
        if (original.field_78805_m != null)
            for (Object childModel : original.field_78805_m)
                this.func_78792_a((ModelRenderer) childModel);
        if (original.field_78804_l != null)
            for (Object cube : original.field_78804_l)
                this.field_78804_l.add((ModelBox) cube);
        this.field_78809_i = original.field_78809_i;
        this.field_78807_k = original.field_78807_k;
        this.field_78806_j = original.field_78806_j;
    }

    @Override
    public void func_78785_a(float f) {
        if ((!ignoreRender && !ignoreBase) || forceRender)
            doRender(f, ignoreBase);
    }

    public void renderIgnoreBase(float f) {
        if (ignoreBase)
            doRender(f, false);
    }

    public void doRender(float f, boolean useParentTransformations) {
        if (!preRender(f))
            return;
        preTransforms(f, true, useParentTransformations);
        GL11.glCallList(field_78811_r);
        if (field_78805_m != null)
            for (int i = 0; i < field_78805_m.size(); i++)
                field_78805_m.get(i).func_78785_a(f);
        postTransforms(f, true, useParentTransformations);
    }

    private boolean preRender(float f) {
        if (field_78807_k || !field_78806_j)
            return false;
        if (!field_78812_q)
            this.func_78788_d(f);
        return true;
    }

    public void preTransforms(float f, boolean push, boolean useParentTransformations) {
        if (base != null && !ignoreBase && useParentTransformations)
            base.preTransforms(f, push, true);
        preTransform(f, push);
    }

    private static FloatBuffer buffer = BufferUtils.createFloatBuffer(16);
    private static float[] array = new float[16];

    public void preTransform(float f, boolean push) {
        if (field_78795_f != 0.0F || field_78796_g != 0.0F || field_78808_h != 0.0F || ignoreSuperRotation) {
            if (push)
                GL11.glPushMatrix();

            GL11.glTranslatef(field_78800_c * f, field_78797_d * f, field_78798_e * f);

            if (ignoreSuperRotation) {
                buffer.rewind();
                GL11.glGetFloat(GL11.GL_MODELVIEW_MATRIX, buffer);
                buffer.get(array);

                GL11.glLoadIdentity();
                GL11.glTranslatef(array[12] / array[15], array[13] / array[15], array[14] / array[15]);
            }

            rotate(rotationOrder, field_78795_f, field_78796_g, field_78808_h);

            GL11.glScalef(scaleX, scaleY, scaleZ);
            GL11.glTranslatef(field_82906_o, field_82908_p, field_82907_q);
        } else if (field_78800_c != 0.0F || field_78797_d != 0.0F || field_78798_e != 0.0F || scaleX != 1.0F || scaleY != 1.0F || scaleZ != 1.0F || field_82906_o != 0.0F
                || field_82908_p != 0.0F || field_82907_q != 0.0F) {
            GL11.glTranslatef(field_78800_c * f, field_78797_d * f, field_78798_e * f);
            GL11.glScalef(scaleX, scaleY, scaleZ);
            GL11.glTranslatef(field_82906_o, field_82908_p, field_82907_q);
        }
    }

    private static void rotate(RotationOrder rotationOrder, float rotateAngleX, float rotateAngleY, float rotateAngleZ) {
        if (rotationOrder == RotationOrder.ZXY && rotateAngleY != 0.0F)
            GL11.glRotatef(rotateAngleY * RadianToAngle, 0.0F, 1.0F, 0.0F);

        if (rotationOrder == RotationOrder.YXZ && rotateAngleZ != 0.0F)
            GL11.glRotatef(rotateAngleZ * RadianToAngle, 0.0F, 0.0F, 1.0F);

        if ((rotationOrder == RotationOrder.YZX || rotationOrder == RotationOrder.YXZ || rotationOrder == RotationOrder.ZXY || rotationOrder == RotationOrder.ZYX)
                && rotateAngleX != 0.0F)
            GL11.glRotatef(rotateAngleX * RadianToAngle, 1.0F, 0.0F, 0.0F);

        if ((rotationOrder == RotationOrder.XZY || rotationOrder == RotationOrder.ZYX)
                && rotateAngleY != 0.0F)
            GL11.glRotatef(rotateAngleY * RadianToAngle, 0.0F, 1.0F, 0.0F);

        if ((rotationOrder == RotationOrder.XYZ || rotationOrder == RotationOrder.XZY || rotationOrder == RotationOrder.YZX || rotationOrder == RotationOrder.ZXY
                || rotationOrder == RotationOrder.ZYX) && rotateAngleZ != 0.0F)
            GL11.glRotatef(rotateAngleZ * RadianToAngle, 0.0F, 0.0F, 1.0F);

        if ((rotationOrder == RotationOrder.XYZ || rotationOrder == RotationOrder.YXZ || rotationOrder == RotationOrder.YZX) && rotateAngleY != 0.0F)
            GL11.glRotatef(rotateAngleY * RadianToAngle, 0.0F, 1.0F, 0.0F);

        if ((rotationOrder == RotationOrder.XYZ || rotationOrder == RotationOrder.XZY) && rotateAngleX != 0.0F)
            GL11.glRotatef(rotateAngleX * RadianToAngle, 1.0F, 0.0F, 0.0F);
    }

    public void postTransform(float f, boolean pop) {
        if (field_78795_f != 0.0F || field_78796_g != 0.0F || field_78808_h != 0.0F || ignoreSuperRotation) {
            if (pop)
                GL11.glPopMatrix();
        } else if (field_78800_c != 0.0F || field_78797_d != 0.0F || field_78798_e != 0.0F || scaleX != 1.0F || scaleY != 1.0F || scaleZ != 1.0F || field_82906_o != 0.0F
                || field_82908_p != 0.0F || field_82907_q != 0.0F) {
            GL11.glTranslatef(-field_82906_o, -field_82908_p, -field_82907_q);
            GL11.glScalef(1F / scaleX, 1F / scaleY, 1F / scaleZ);
            GL11.glTranslatef(-field_78800_c * f, -field_78797_d * f, -field_78798_e * f);
        }
    }

    public void postTransforms(float f, boolean pop, boolean useParentTransformations) {
        postTransform(f, pop);
        if (base != null && !ignoreBase && useParentTransformations)
            base.postTransforms(f, pop, true);
    }

    public void reset() {
        rotationOrder = RotationOrder.XYZ;

        scaleX = scaleY = scaleZ = 1.0F;

        field_78800_c = field_78797_d = field_78798_e = 0F;

        field_78795_f = field_78796_g = field_78808_h = 0F;

        ignoreBase = false;
        ignoreSuperRotation = false;
        forceRender = false;

        field_82906_o = field_82908_p = field_82907_q = 0;
    }

    @Override
    public void func_78794_c(float f) {
        if (!preRender(f))
            return;
        preTransforms(f, false, true);
    }

    public boolean canBeRandomBoxSource() {
        return true;
    }
}
