/*
* Smart Moving Reloaded
* Copyright (C) 2018  Tommsy64
*
* Smart Moving Reloaded is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* Smart Moving Reloaded is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with Smart Moving Reloaded.  If not, see <http://www.gnu.org/licenses/>.
*/

package com.tommsy.smartmoving.client.renderer.layers;

import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

import com.tommsy.smartmoving.client.model.SmartMovingModelElytra;
import com.tommsy.smartmoving.client.model.SmartMovingModelPlayer;

public class SmartMovingLayerElytra implements LayerRenderer<AbstractClientPlayer> {

    protected final RenderLivingBase<AbstractClientPlayer> renderPlayer;
    private final SmartMovingModelElytra modelElytra;

    public SmartMovingLayerElytra(RenderLivingBase<AbstractClientPlayer> renderPlayer) {
        this.renderPlayer = renderPlayer;
        this.modelElytra = new SmartMovingModelElytra((SmartMovingModelPlayer) renderPlayer.func_177087_b());
    }

    public void func_177141_a(AbstractClientPlayer abstractClientPlayer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw,
            float headPitch, float scale) {
        ItemStack itemstack = abstractClientPlayer.func_184582_a(EntityEquipmentSlot.CHEST);
        if (itemstack.func_77973_b() != Items.field_185160_cR)
            return;

        GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a(GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);

        if (abstractClientPlayer.func_184833_s() && abstractClientPlayer.func_184834_t() != null)
            this.renderPlayer.func_110776_a(abstractClientPlayer.func_184834_t());
        else if (abstractClientPlayer.func_152122_n() && abstractClientPlayer.func_110303_q() != null && abstractClientPlayer.func_175148_a(EnumPlayerModelParts.CAPE))
            this.renderPlayer.func_110776_a(abstractClientPlayer.func_110303_q());
        else
            this.renderPlayer.func_110776_a(LayerElytra.field_188355_a);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b(0.0F, 0.0F, 0.125F);
        this.modelElytra.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, abstractClientPlayer);
        this.modelElytra.func_78088_a(abstractClientPlayer, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);

        if (itemstack.func_77948_v())
            LayerArmorBase.func_188364_a(this.renderPlayer, abstractClientPlayer, this.modelElytra, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw,
                    headPitch, scale);

        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean func_177142_b() {
        return false;
    }
}
