/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.handler;

import bre.smoothfont.FontRasterizer;
import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontTextureManager;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.handler.Timer;
import bre.smoothfont.util.GLUtils;
import bre.smoothfont.util.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class TimerEventHandler {
    private int counter = 0;
    private McDefFontRendererChecker mcDefFontRendererChecker = new McDefFontRendererChecker();
    private ExtShaderChecker extShaderChecker = new ExtShaderChecker();
    private static List<Timer> timerList = new ArrayList<Timer>();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++this.counter;
            if (this.counter > 20) {
                this.counter = 0;
                this.mcDefFontRendererChecker.check();
                this.processTimer();
            }
        }
    }

    public static void addTimer(Timer timer) {
        timerList.add(timer);
    }

    private void processTimer() {
        Iterator<Timer> it = timerList.iterator();
        while (it.hasNext()) {
            Timer timer = it.next();
            if (!timer.checkTimeout()) continue;
            it.remove();
        }
    }

    private class ExtShaderChecker {
        private boolean needCheck;

        private ExtShaderChecker() {
        }

        protected void intendToCheck() {
            this.needCheck = true;
        }

        protected void checkIfPlanned() {
            if (!this.needCheck) {
                return;
            }
            this.needCheck = false;
            this.check();
        }

        protected void check() {
            if (!GLUtils.shaderSupported) {
                return;
            }
            int runningShaderProg = GL11.glGetInteger((int)35725);
            if (runningShaderProg == 0) {
                if (FontRendererHook.extShaderWorking && CommonConfig.currentConfig.useOSFont && FontRasterizer.getInstance().grayScale) {
                    FontTextureManager.getInstance().clearMapTextureObjects();
                    Logger.debug("No shader enabled. Can use alpha texture.");
                }
                FontRendererHook.extShaderWorking = false;
            } else {
                if (!FontRendererHook.extShaderWorking && CommonConfig.currentConfig.useOSFont && FontRasterizer.getInstance().grayScale) {
                    FontTextureManager.getInstance().clearMapTextureObjects();
                    Logger.debug("Other shader is enabled. Use ABGR texture.");
                }
                FontRendererHook.extShaderWorking = true;
            }
        }
    }

    private class McDefFontRendererChecker {
        private FontRenderer mcFontRenderer = null;

        private McDefFontRendererChecker() {
        }

        protected void check() {
            if (this.mcFontRenderer != Minecraft.func_71410_x().field_71466_p && FontRendererHook.modLoaded) {
                this.mcFontRenderer = Minecraft.func_71410_x().field_71466_p;
                FontRendererHook frh = FontRendererHook.getMcDefaultFontRendererHook();
                if (frh != null) {
                    if (CommonConfig.globalConfig.mcStdRendererNotUseHighPRC) {
                        if (frh.precisionMode == 0) {
                            frh.precisionMode = 1;
                            Logger.info("Changed mc.fontRenderer precision mode to normal.");
                        }
                    } else if (frh.precisionMode != 0 && CommonConfig.globalConfig.setMcRendererToHighPRC) {
                        frh.precisionMode = 0;
                        Logger.info("Changed mc.fontRenderer precision mode to high.");
                    }
                }
            }
        }
    }
}

