/*
 * Decompiled with CFR 0.152.
 */
package squeek.speedometer;

import net.minecraft.client.resources.I18n;

public enum SpeedUnit {
    BLOCKSPERTICK(1.0f, "bpt"),
    BLOCKSPERSECOND(0.05f, "bps"),
    METERSPERSECOND(0.05f, "ms"),
    KILOMETERSPERHOUR(0.0138889f, "kmh"),
    MILESPERHOUR(0.022352f, "mph");

    private final float conversionFromBlocksPerTick;
    public final String name;
    public final String minimalName;
    private final String id;

    private SpeedUnit(float conversionFromBlocksPerTick, String id) {
        this.conversionFromBlocksPerTick = conversionFromBlocksPerTick;
        this.name = I18n.func_135052_a((String)("squeedometer.unit." + id), (Object[])new Object[0]);
        this.minimalName = I18n.func_188566_a((String)("squeedometer.unit.min." + id)) ? I18n.func_135052_a((String)("squeedometer.unit.min." + id), (Object[])new Object[0]) : this.name;
        this.id = id;
    }

    public double convertTo(double speedInBlocksPerTick) {
        return speedInBlocksPerTick / (double)this.conversionFromBlocksPerTick;
    }

    public double convertFrom(double speedInUnit) {
        return speedInUnit * (double)this.conversionFromBlocksPerTick;
    }

    public String getId() {
        return this.id;
    }

    public final String toString() {
        return this.name;
    }

    public static SpeedUnit getById(String id) {
        for (SpeedUnit unit : SpeedUnit.getUnits()) {
            if (!unit.id.equals(id)) continue;
            return unit;
        }
        return null;
    }

    public static SpeedUnit[] getUnits() {
        return SpeedUnit.values();
    }
}

