/*
 * Decompiled with CFR 0.152.
 */
package squeek.speedometer.gui.widget;

import squeek.speedometer.gui.GuiEvent;
import squeek.speedometer.gui.IGuiHierarchical;
import squeek.speedometer.gui.widget.IWidget;
import squeek.speedometer.gui.widget.WidgetBase;
import squeek.speedometer.gui.widget.WidgetBox;

public class WidgetWrapper
extends WidgetBase {
    protected WidgetBox bounds = new WidgetBox(null, 0, 0, 0, 0, 0x3300FF00);

    public WidgetWrapper(IGuiHierarchical parent) {
        super(parent, 0, 0, 0, 0);
    }

    @Override
    public void setPos(int x, int y) {
        if (this.bounds != null) {
            this.bounds.setPos(x, y);
        }
        super.setPos(x, y);
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        if (this.bounds != null) {
            this.bounds.setSize(w, h);
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        super.drawBackground(mouseX, mouseY);
    }

    @Override
    protected void onChildAdded(IWidget child) {
        super.onChildAdded(child);
        child.setPos(this.getX() + child.getX(), this.getY() + child.getY());
    }

    @Override
    public void onGuiEvent(GuiEvent event, Object source, Object[] data) {
        if (event == GuiEvent.LAYOUT_CHANGED && source != this) {
            this.determineBounds();
            return;
        }
        super.onGuiEvent(event, source, data);
    }

    @Override
    protected void onChildrenChanged() {
        super.onChildrenChanged();
        this.determineBounds();
    }

    public void determineBounds() {
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        boolean isInitialized = false;
        for (IWidget child : this.children) {
            if (!isInitialized) {
                minX = child.getX();
                maxX = minX + child.getWidth();
                minY = child.getY();
                maxY = minY + child.getHeight();
                isInitialized = true;
                continue;
            }
            if (child.getX() < minX) {
                minX = child.getX();
            }
            if (child.getX() + child.getWidth() > maxX) {
                maxX = child.getX() + child.getWidth();
            }
            if (child.getY() < minY) {
                minY = child.getY();
            }
            if (child.getY() + child.getHeight() <= maxY) continue;
            maxY = child.getY() + child.getHeight();
        }
        this.setSize(maxX - minX, maxY - minY);
    }
}

