/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.blocks.cake;

import com.mrbysco.telepastries.blocks.BlockPastryBase;
import com.mrbysco.telepastries.config.TeleConfig;
import com.mrbysco.telepastries.util.CakeTeleporter;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;

public class BlockCakeBase
extends BlockPastryBase {
    public static final IntegerProperty BITES = BlockStateProperties.field_208173_Z;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};

    public BlockCakeBase(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(0.5f).func_200947_a(SoundType.field_185854_g).func_200944_c());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)BITES)];
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            ItemStack stack = player.func_184586_b(handIn);
            if (this.consumeCake()) {
                if (!stack.func_190926_b() && this.isRefillItem(stack)) {
                    int i = (Integer)state.func_177229_b((Property)BITES);
                    if (i > 0) {
                        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BITES, (Comparable)Integer.valueOf(i - 1)), 3);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (worldIn.func_234923_W_() != this.getCakeWorld()) {
                    if (((Boolean)TeleConfig.SERVER.resetPastry.get()).booleanValue() && this.isResetItem(stack)) {
                        this.removeDimensionPosition((ServerPlayerEntity)player, this.getCakeWorld());
                        if (stack.func_77973_b() == Items.field_151117_aB && !player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                            player.func_184611_a(handIn, new ItemStack((IItemProvider)Items.field_151133_ar));
                        }
                        return ActionResultType.SUCCESS;
                    }
                    if (this.eatSlice((IWorld)worldIn, pos, state, player).func_226246_a_()) {
                        return ActionResultType.SUCCESS;
                    }
                    return ActionResultType.FAIL;
                }
                return ActionResultType.FAIL;
            }
            if (stack.func_190926_b()) {
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.SUCCESS;
    }

    private ActionResultType eatSlice(IWorld world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!player.func_71043_e(false)) {
            return ActionResultType.PASS;
        }
        player.func_195066_a(Stats.field_188076_J);
        player.func_71024_bL().func_75122_a(2, 0.1f);
        if (!player.field_71075_bZ.field_75098_d) {
            int i = (Integer)state.func_177229_b((Property)BITES);
            if (i < 6) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
            } else {
                world.func_217377_a(pos, false);
            }
        }
        if (!ForgeHooks.onTravelToDimension((Entity)player, this.getCakeWorld())) {
            return ActionResultType.SUCCESS;
        }
        this.teleportToDimension(world, pos, player);
        return ActionResultType.SUCCESS;
    }

    private boolean isResetItem(ItemStack stack) {
        List items = (List)TeleConfig.SERVER.resetItems.get();
        if (items == null || items.isEmpty()) {
            return false;
        }
        ResourceLocation registryLocation = stack.func_77973_b().getRegistryName();
        return registryLocation != null && items.contains(registryLocation.toString());
    }

    public void teleportToDimension(IWorld worldIn, BlockPos pos, PlayerEntity player) {
        if (player.func_70089_S() && !worldIn.func_201670_d()) {
            ServerWorld world = ((IServerWorld)worldIn).func_201672_e();
            if (!world.field_72995_K && !player.func_184218_aH() && !player.func_184207_aI() && player.func_184222_aU()) {
                ServerWorld destinationWorld;
                ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
                MinecraftServer server = player.func_184102_h();
                ServerWorld serverWorld = destinationWorld = server != null ? server.func_71218_a(this.getCakeWorld()) : null;
                if (destinationWorld == null) {
                    return;
                }
                CakeTeleporter teleporter = new CakeTeleporter(destinationWorld);
                teleporter.addDimensionPosition((Entity)playerMP, (RegistryKey<World>)playerMP.func_71121_q().func_234923_W_(), playerMP.func_233580_cy_().func_177982_a(0, 1, 0));
                playerMP.changeDimension(destinationWorld, (ITeleporter)teleporter);
            }
        }
    }

    public boolean isRefillItem(ItemStack stack) {
        return false;
    }

    public RegistryKey<World> getCakeWorld() {
        return World.field_234918_g_;
    }

    public boolean consumeCake() {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BITES});
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (7 - (Integer)blockState.func_177229_b((Property)BITES)) * 2;
    }

    protected void removeDimensionPosition(ServerPlayerEntity player, RegistryKey<World> dim) {
        CompoundNBT playerData = player.getPersistentData();
        CompoundNBT data = this.getTag(playerData);
        if (data.func_74764_b("telepastries:" + dim.func_240901_a_())) {
            data.func_82580_o("telepastries:" + dim.func_240901_a_());
            player.func_145747_a((ITextComponent)new TranslationTextComponent("telepastries.pastry.reset.complete", new Object[]{dim.func_240901_a_()}), Util.field_240973_b_);
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("telepastries.pastry.reset.failed", new Object[]{dim.func_240901_a_()}), Util.field_240973_b_);
        }
        playerData.func_218657_a("PlayerPersisted", (INBT)data);
    }

    protected CompoundNBT getTag(CompoundNBT tag) {
        if (tag == null || !tag.func_74764_b("PlayerPersisted")) {
            return new CompoundNBT();
        }
        return tag.func_74775_l("PlayerPersisted");
    }
}

