/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.config;

import com.mrbysco.telepastries.TelePastries;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class TeleConfig {
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        TelePastries.LOGGER.debug("Loaded TelePastries' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        TelePastries.LOGGER.debug("TelePastries' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue resetPastry;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> resetItems;
        public final ForgeConfigSpec.BooleanValue consumeNetherCake;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> netherCakeRefillItems;
        public final ForgeConfigSpec.BooleanValue netherCake1x1Logic;
        public final ForgeConfigSpec.BooleanValue consumeEndCake;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> endCakeRefillItems;
        public final ForgeConfigSpec.BooleanValue consumeOverworldCake;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> overworldCakeRefillItems;
        public final ForgeConfigSpec.BooleanValue consumeTwilightCake;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> TwilightCakeRefillItems;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.resetPastry = builder.comment("Defines if the pastry teleportation point can be reset with a milk bucket [default: false]").define("resetPastry", false);
            String[] resetItem = new String[]{"minecraft:milk_bucket"};
            this.resetItems = builder.comment("Defines the item needed to reset the pastry teleportation point [default: minecraft:milk_bucket]").defineList("resetItems", Arrays.asList(resetItem), o -> o instanceof String);
            builder.pop();
            builder.comment("Nether settings").push("Nether");
            this.consumeNetherCake = builder.comment("Defines if the Nether Cake gets partly consumed when eaten [default: true]").define("consumeNetherCake", true);
            String[] netherItems = new String[]{"minecraft:obsidian"};
            this.netherCakeRefillItems = builder.comment("Set the refill items used by Nether Cake (Only change if you know what you're doing) [modid:itemname].").defineList("netherCakeRefillItems", Arrays.asList(netherItems), o -> o instanceof String);
            this.netherCake1x1Logic = builder.comment("Defines if the Nether Cake should teleport the player 1x1 (Use this if you're replacing the Nether dimension with one that is 1x1) [default: false].").define("netherCake1x1Logic", false);
            builder.pop();
            builder.comment("End settings").push("End");
            this.consumeEndCake = builder.comment("Defines if the End Cake gets partly consumed when eaten [default: true]").define("consumeEndCake", true);
            String[] endItems = new String[]{"minecraft:ender_eye"};
            this.endCakeRefillItems = builder.comment("Set the refill items used by End Cake (Only change if you know what you're doing) [modid:itemname].").defineList("endCakeRefillItems", Arrays.asList(endItems), o -> o instanceof String);
            builder.pop();
            builder.comment("Overworld settings").push("Overworld");
            this.consumeOverworldCake = builder.comment("Defines if the Overworld Cake gets partly consumed when eaten [default: true]").define("consumeOverworldCake", true);
            String[] overworldItems = new String[]{"minecraft:oak_sapling", "minecraft:spruce_sapling", "minecraft:birch_sapling", "minecraft:jungle_sapling", "minecraft:acacia_sapling", "minecraft:dark_oak_sapling"};
            this.overworldCakeRefillItems = builder.comment("Set the refill items used by Overworld Cake (Only change if you know what you're doing) [modid:itemname].").defineList("overworldCakeRefillItems", Arrays.asList(overworldItems), o -> o instanceof String);
            builder.pop();
            builder.comment("Compat settings").push("Compat");
            this.consumeTwilightCake = builder.comment("Defines if the Twilight Forest Cake gets partly consumed when eaten [default: true]").define("consumeTwilightCake", true);
            String[] twilightItems = new String[]{"minecraft:diamond"};
            this.TwilightCakeRefillItems = builder.comment("Set the refill items used by Twilight Forest Cake (Only change if you know what you're doing) [modid:itemname]").defineList("TwilightCakeRefillItems", Arrays.asList(twilightItems), o -> o instanceof String);
            builder.pop();
        }
    }
}

