/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.util;

import com.mrbysco.telepastries.config.TeleConfig;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.ModList;

public class CakeTeleporter
implements ITeleporter {
    protected final ServerWorld world;

    public CakeTeleporter(ServerWorld worldIn) {
        this.world = worldIn;
    }

    public Entity placeEntity(Entity newEntity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        Entity entity = repositionEntity.apply(false);
        BlockPos dimPos = this.getDimensionPosition(entity, (RegistryKey<World>)destWorld.func_234923_W_(), entity.func_233580_cy_());
        this.doSafetyChecks(entity, currentWorld, destWorld, (double)dimPos.func_177958_n() + 0.5, dimPos.func_177956_o(), (double)dimPos.func_177952_p() + 0.5);
        return entity;
    }

    public void doSafetyChecks(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, double x, double y, double z) {
        this.world.func_184148_a(null, x + 0.5, y + 0.5, z + 0.5, SoundEvents.field_187812_eh, SoundCategory.MASTER, 0.25f, this.world.field_73012_v.nextFloat() * 0.4f + 0.8f);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76429_m, 200, 200, false, false));
        }
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147364_a(x, y, z, entity.field_70177_z, entity.field_70125_A);
        } else {
            entity.func_70012_b(x, y, z, entity.field_70177_z, 0.0f);
        }
        entity.func_213317_d(Vector3d.field_186680_a);
        if (destWorld.func_234923_W_() == World.field_234919_h_) {
            this.relocateInNether(entity, x, y, z);
        } else if (destWorld.func_234923_W_() == World.field_234920_i_) {
            this.endPlacement(entity);
        } else if (destWorld.func_234923_W_() != World.field_234918_g_) {
            this.customCompat(entity, destWorld);
        }
    }

    public void addDimensionPosition(Entity entityIn, RegistryKey<World> dim, BlockPos position) {
        CompoundNBT entityData = entityIn.getPersistentData();
        CompoundNBT data = this.getTag(entityData);
        ResourceLocation dimLocation = dim.func_240901_a_();
        if (dim == World.field_234920_i_) {
            entityIn.func_184102_h().func_71218_a(dim);
            BlockPos spawnPlatform = ServerWorld.field_241108_a_;
            System.out.println("Setting position of " + dimLocation + " to: " + spawnPlatform);
            data.func_74772_a("telepastries:" + dimLocation, spawnPlatform.func_218275_a());
        } else {
            System.out.println("Setting position of " + dimLocation + " to: " + position);
            data.func_74772_a("telepastries:" + dimLocation, position.func_218275_a());
        }
        entityData.func_218657_a("PlayerPersisted", (INBT)data);
    }

    public BlockPos getDimensionPosition(Entity entityIn, RegistryKey<World> dim, BlockPos position) {
        CompoundNBT entityData = entityIn.getPersistentData();
        CompoundNBT data = this.getTag(entityData);
        ResourceLocation dimLocation = dim.func_240901_a_();
        BlockPos dimPos = position;
        if (data.func_74764_b("telepastries:" + dimLocation)) {
            dimPos = BlockPos.func_218283_e((long)data.func_74763_f("telepastries:" + dimLocation));
            System.out.println("Found position of " + dimLocation + " to: " + dimPos);
            return dimPos;
        }
        System.out.println("Could not find previous location. Using current location");
        return dimPos;
    }

    public boolean hasDimensionPosition(Entity entityIn, RegistryKey<World> dim) {
        CompoundNBT entityData = entityIn.getPersistentData();
        CompoundNBT data = this.getTag(entityData);
        System.out.println("Checking if entity has position stored for : " + dim.func_240901_a_());
        return data.func_74764_b("telepastries:" + dim.func_240901_a_());
    }

    private CompoundNBT getTag(CompoundNBT tag) {
        if (tag == null || !tag.func_74764_b("PlayerPersisted")) {
            return new CompoundNBT();
        }
        return tag.func_74775_l("PlayerPersisted");
    }

    private void endPlacement(Entity entityIn) {
        int i = MathHelper.func_76128_c((double)entityIn.func_226277_ct_());
        int j = MathHelper.func_76128_c((double)entityIn.func_226278_cu_()) - 1;
        int k = MathHelper.func_76128_c((double)entityIn.func_226281_cx_());
        for (int j1 = -2; j1 <= 2; ++j1) {
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -1; l1 < 3; ++l1) {
                    int i2 = i + k1 * 1 + j1 * 0;
                    int j2 = j + l1;
                    int k2 = k + k1 * 0 - j1 * 1;
                    boolean flag = l1 < 0;
                    this.world.func_175656_a(new BlockPos(i2, j2, k2), flag ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    private void relocateInNether(Entity entityIn, double x, double y, double z) {
        if (((Boolean)TeleConfig.SERVER.netherCake1x1Logic.get()).booleanValue()) {
            this.protectEntity(entityIn, new BlockPos(x, y, z));
        } else if (this.hasDimensionPosition(entityIn, (RegistryKey<World>)World.field_234919_h_)) {
            this.protectEntity(entityIn, new BlockPos(x, y, z));
        } else {
            double moveFactor = 0.125;
            double d0 = MathHelper.func_151237_a((double)(x * moveFactor), (double)(this.world.func_175723_af().func_177726_b() + 16.0), (double)(this.world.func_175723_af().func_177728_d() - 16.0));
            double d1 = MathHelper.func_151237_a((double)(z * moveFactor), (double)(this.world.func_175723_af().func_177736_c() + 16.0), (double)(this.world.func_175723_af().func_177733_e() - 16.0));
            double d2 = 8.0;
            d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
            d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
            double newY = MathHelper.func_151237_a((double)y, (double)70.0, (double)(this.world.func_217301_I() - 10));
            this.protectEntity(entityIn, new BlockPos(d0, newY, d1));
        }
    }

    private void protectEntity(Entity playerIn, BlockPos position) {
        boolean foundSuitablePlatform = false;
        if (this.world.func_234923_W_() != World.field_234918_g_) {
            for (int j1 = 0; j1 < 5; ++j1) {
                BlockPos checkingPos = position.func_177982_a(0, -j1, 0);
                if (!this.world.func_180495_p(checkingPos).func_200132_m()) continue;
                foundSuitablePlatform = true;
                break;
            }
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos testPos;
                    if (!(x != -2 && x != 2 || z != -2 && z != 2)) {
                        testPos = new BlockPos((Vector3i)position.func_177982_a(x, 3, z));
                        if (this.world.func_180495_p(testPos).func_200132_m() || !this.world.func_180495_p(testPos).func_185904_a().func_76224_d()) continue;
                        this.world.func_175656_a(testPos, Blocks.field_150343_Z.func_176223_P());
                        continue;
                    }
                    if (this.world.func_180495_p(position.func_177982_a(x, 3, z)).func_185904_a().func_76224_d()) {
                        this.world.func_175656_a(position.func_177982_a(x, 3, z), Blocks.field_150343_Z.func_176223_P());
                    }
                    if (foundSuitablePlatform || this.world.func_180495_p(testPos = new BlockPos((Vector3i)position.func_177982_a(x, -2, z))).func_200132_m() && !this.world.func_180495_p(testPos).func_185904_a().func_76224_d()) continue;
                    this.world.func_175656_a(testPos, Blocks.field_150343_Z.func_176223_P());
                }
            }
        }
        BlockPos platformPos = new BlockPos((Vector3i)position.func_177982_a(1, 2, 1));
        for (int y = 1; y <= 3; ++y) {
            if (!this.world.func_180495_p(position.func_177982_a(0, y, 0)).func_200132_m() && !this.world.func_180495_p(position.func_177982_a(0, y, 0)).func_185904_a().func_76224_d()) continue;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos testPos = position.func_177982_a(x, y, z);
                    if (!this.world.func_180495_p(testPos).func_200132_m() && !this.world.func_180495_p(testPos).func_185904_a().func_76224_d()) continue;
                    this.world.func_217377_a(testPos, false);
                }
            }
        }
        playerIn.func_70012_b((double)position.func_177958_n() + 0.5, (double)platformPos.func_177956_o(), (double)position.func_177952_p() + 0.5, 90.0f, 0.0f);
        playerIn.func_70634_a((double)position.func_177958_n() + 0.5, (double)platformPos.func_177956_o(), (double)position.func_177952_p() + 0.5);
    }

    private void customCompat(Entity entity, ServerWorld destWorld) {
        if (ModList.get().isLoaded("twilightforest")) {
            RegistryKey twilightKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("twilightforest", "twilightforest"));
            if (destWorld.func_234923_W_() == twilightKey) {
                this.protectEntity(entity, entity.func_233580_cy_());
                if (entity instanceof ServerPlayerEntity) {
                    ServerPlayerEntity playerMP = (ServerPlayerEntity)entity;
                    playerMP.func_242111_a(twilightKey, playerMP.func_233580_cy_(), playerMP.field_70177_z, true, false);
                }
            }
        }
    }

    public boolean aboveMax(BlockPos pos) {
        boolean flag1 = this.world.func_234923_W_() == World.field_234919_h_ && (Boolean)TeleConfig.SERVER.netherCake1x1Logic.get() == false && (pos.func_177956_o() >= 122 || pos.func_177982_a(0, 1, 0).func_177956_o() >= 122);
        boolean flag2 = ServerWorld.func_189509_E((BlockPos)pos);
        return flag1 || flag2;
    }
}

