/*
 * Decompiled with CFR 0.152.
 */
package com.spedoske.commands.commands;

import com.spedoske.commands.init.CommandInitializer;
import com.spedoske.commands.init.LangInitializer;
import com.spedoske.commands.io.WorldDataSaver;
import com.spedoske.commands.util.HomePos;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CommandBACK
extends CommandBase {
    public String func_71517_b() {
        return "back";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender instanceof EntityPlayerMP;
    }

    public String func_71518_a(ICommandSender sender) {
        return LangInitializer.translate(sender, "command.back.usage", new Object[0]);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            HomePos node = (HomePos)WorldDataSaver.instance.backList.computeIfAbsent(sender.func_70005_c_(), k -> new HashMap()).get(((EntityPlayerMP)sender).field_71093_bK);
            CommandBACK.updateBackList(sender);
            if (node != null) {
                ((EntityPlayerMP)sender).func_70634_a(node.x, node.y, node.z);
            }
        } else {
            throw new WrongUsageException(LangInitializer.translate(sender, "command.home.usage", new Object[0]), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    @SubscribeEvent
    public static void playerOnDeath(LivingDeathEvent event) {
        Entity e = event.getEntity();
        if (e instanceof EntityPlayer) {
            WorldDataSaver.instance.backList.computeIfAbsent(e.func_70005_c_(), k -> new HashMap()).put(((EntityPlayerMP)e).field_71093_bK, new HomePos(e.field_70165_t, e.field_70163_u, e.field_70161_v));
            WorldDataSaver.instance.func_76185_a();
        }
    }

    @SubscribeEvent
    public static void playerOnSleep(PlayerSleepInBedEvent event) {
        EntityPlayerMP sender = (EntityPlayerMP)event.getEntityPlayer();
        HashMap node = WorldDataSaver.instance.homes.computeIfAbsent(sender.func_70005_c_(), k -> new HashMap()).computeIfAbsent(sender.field_71093_bK, k -> new HashMap());
        node.compute("", (k, o) -> new HomePos(sender.field_70165_t, sender.field_70163_u, sender.field_70161_v));
        CommandInitializer.sendString(sender, LangInitializer.translate(sender, "command.sethome.setSuccess", new Object[0]), TextFormatting.GREEN);
        WorldDataSaver.instance.func_76185_a();
    }

    @SubscribeEvent
    public static void playerUseCommand(CommandEvent event) {
        if (event.getSender() instanceof EntityPlayerMP) {
            EntityPlayerMP sender = (EntityPlayerMP)event.getSender();
            String name = event.getCommand().func_71517_b();
            if (name.equals("teleport")) {
                try {
                    MinecraftServer server = sender.func_184102_h();
                    if (server != null) {
                        EntityPlayerMP player = CommandBACK.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)event.getParameters()[0]);
                        CommandBACK.updateBackList(player);
                    }
                }
                catch (CommandException server) {}
            } else if (name.equals("tp")) {
                int paraLen = event.getParameters().length;
                if (paraLen == 1) {
                    CommandBACK.updateBackList(sender);
                } else if (paraLen > 1) {
                    try {
                        MinecraftServer server = sender.func_184102_h();
                        if (server != null) {
                            EntityPlayerMP player = CommandBACK.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)event.getParameters()[0]);
                            CommandBACK.updateBackList(player);
                        }
                    }
                    catch (CommandException commandException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static <T extends ICommandSender> void updateBackList(T e) {
        WorldDataSaver.instance.backList.computeIfAbsent(e.func_70005_c_(), k -> new HashMap()).put(((EntityPlayerMP)e).field_71093_bK, new HomePos(((EntityPlayerMP)e).field_70165_t, ((EntityPlayerMP)e).field_70163_u, ((EntityPlayerMP)e).field_70161_v));
        WorldDataSaver.instance.func_76185_a();
    }
}

